# API Testing Examples

## Test API dengan Postman atau cURL

### 1. Test Login API

**URL:** `POST http://localhost:8000/api/auth/login`

**Headers:**
```
Content-Type: application/json
Accept: application/json
```

**Body (JSON):**
```json
{
    "login": "admin@example.com",
    "password": "password123"
}
```

**cURL Command (FIXED):**
```bash
curl --location 'http://192.168.1.8:8087/api/auth/login' \
--header 'Content-Type: application/json' \
--header 'Accept: application/json' \
--data-raw '{
    "login": "admin@gmail.com",
    "password": "12345678"
}'
```

**Expected Response:**
```json
{
    "success": true,
    "message": "Login berhasil",
    "data": {
        "user": {
            "id": 1,
            "name": "Admin User",
            "username": "admin",
            "email": "admin@example.com",
            "role": "Admin",
            "profile": null
        },
        "token": "1|abc123def456...",
        "token_type": "Bearer"
    }
}
```

### 2. Test Profile API

**URL:** `GET http://localhost:8000/api/auth/profile`

**Headers:**
```
Authorization: Bearer YOUR_TOKEN_HERE
Accept: application/json
```

**Expected Response:**
```json
{
    "success": true,
    "message": "Data user berhasil diambil",
    "data": {
        "user": {
            "id": 1,
            "name": "Admin User",
            "username": "admin",
            "email": "admin@example.com",
            "role": "Admin",
            "profile": null,
            "created_at": "2025-07-31T18:30:00.000000Z",
            "updated_at": "2025-07-31T18:30:00.000000Z"
        }
    }
}
```

### 3. Test Logout API

**URL:** `POST http://localhost:8000/api/auth/logout`

**Headers:**
```
Authorization: Bearer YOUR_TOKEN_HERE
Accept: application/json
```

**Expected Response:**
```json
{
    "success": true,
    "message": "Logout berhasil"
}
```

## cURL Commands untuk Testing

### Login
```bash
curl -X POST http://localhost:8000/api/auth/login \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "login": "admin@example.com",
    "password": "password123"
  }'
```

### Get Profile (ganti YOUR_TOKEN dengan token dari login)
```bash
curl -X GET http://localhost:8000/api/auth/profile \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

### Logout
```bash
curl -X POST http://localhost:8000/api/auth/logout \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

## Error Cases untuk Testing

### 1. Login dengan credential salah
```bash
curl -X POST http://localhost:8000/api/auth/login \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "login": "wrong@email.com",
    "password": "wrongpassword"
  }'
```

Expected: HTTP 401 dengan message error

### 2. Akses profile tanpa token
```bash
curl -X GET http://localhost:8000/api/auth/profile \
  -H "Accept: application/json"
```

Expected: HTTP 401 Unauthenticated

### 3. Login tanpa parameter required
```bash
curl -X POST http://localhost:8000/api/auth/login \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{}'
```

Expected: HTTP 422 Validation Error
