# API Documentation: Get Gatra Data

## Endpoint
**GET** `/api/gatra`

## Authentication
Required: **Bearer Token**

## Headers
```
Authorization: Bearer {your_token_here}
Content-Type: application/json
Accept: application/json
```

## Request
No request body required for GET request.

## Response

### Success Response (200)
```json
{
    "success": true,
    "message": "Data gatra berhasil diambil",
    "data": {
        "total": 8,
        "gatra": [
            {
                "id": 1,
                "gatra": "Geografi",
                "bobot": 8,
                "skor": "2.82",
                "bobot_x_skor": "22.56",
                "created_at": "2025-07-31T18:57:55.000000Z",
                "updated_at": "2025-07-31T18:57:55.000000Z"
            },
            {
                "id": 2,
                "gatra": "Demografi",
                "bobot": 12,
                "skor": "3.16",
                "bobot_x_skor": "37.92",
                "created_at": "2025-07-31T18:57:55.000000Z",
                "updated_at": "2025-07-31T18:57:55.000000Z"
            }
            // ... more data
        ]
    }
}
```

### Error Responses

#### 401 Unauthorized
```json
{
    "message": "Unauthenticated."
}
```

#### 500 Server Error
```json
{
    "success": false,
    "message": "Terjadi kesalahan server",
    "error": "Error details here"
}
```

## Usage Examples

### cURL
```bash
curl -X GET "http://your-domain.com/api/gatra" \
  -H "Authorization: Bearer your_token_here" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json"
```

### JavaScript (Fetch)
```javascript
fetch('/api/gatra', {
    method: 'GET',
    headers: {
        'Authorization': 'Bearer ' + token,
        'Content-Type': 'application/json',
        'Accept': 'application/json'
    }
})
.then(response => response.json())
.then(data => {
    if (data.success) {
        console.log('Gatra data:', data.data.gatra);
        console.log('Total records:', data.data.total);
    } else {
        console.error('Error:', data.message);
    }
})
.catch(error => {
    console.error('Network error:', error);
});
```

### PHP (using cURL)
```php
$token = 'your_token_here';
$url = 'http://your-domain.com/api/gatra';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $token,
    'Content-Type: application/json',
    'Accept: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200) {
    $data = json_decode($response, true);
    if ($data['success']) {
        echo "Total Gatra: " . $data['data']['total'] . "\n";
        foreach ($data['data']['gatra'] as $item) {
            echo "- {$item['gatra']}: Bobot {$item['bobot']}, Skor {$item['skor']}\n";
        }
    }
} else {
    echo "HTTP Error: " . $httpCode . "\n";
}
```

## How to Get Token

First, login using the login API:

```bash
curl -X POST "http://your-domain.com/api/auth/login" \
  -H "Content-Type: application/json" \
  -d '{
    "login": "your_username_or_email",
    "password": "your_password"
  }'
```

The response will include a token that you can use for authenticated requests.

## Data Structure

Each Gatra item contains:
- **id**: Unique identifier (integer)
- **gatra**: Name/title of the gatra (string)
- **bobot**: Weight/importance value (integer)
- **skor**: Score value (decimal)
- **bobot_x_skor**: Calculated value (bobot × skor) (decimal)
- **created_at**: Creation timestamp
- **updated_at**: Last update timestamp

## Notes
- This endpoint requires valid authentication token
- Returns all Gatra records from the database
- Response includes total count for easy pagination reference
- All decimal values are returned as strings to maintain precision
