from flask import Flask, render_template, request, send_file
from utils.pdf_generator import generate_pdf
import os

app = Flask(__name__)

BASE_DIR = os.path.dirname(os.path.abspath(__file__))


@app.route('/')
def index():
    return render_template('form.html')


@app.route('/generate', methods=['POST'])
def generate():
    form_data = request.form.to_dict()
    output_path = os.path.join(BASE_DIR, 'static', 'result.pdf')

    # Peta template dengan nama file PDF yang benar (case-sensitive)
    template_map = {
        'BBCA': os.path.join(BASE_DIR, 'pdf_templates', 'BBCA_BLANK.pdf'),
        'BANKSAQU': os.path.join(BASE_DIR, 'pdf_templates', 'BANKSAQU_BLANK.pdf'),
        'ALADIN': os.path.join(BASE_DIR, 'pdf_templates', 'ALADIN_BLANK.pdf')
    }

    # Normalisasi nama template dari form agar uppercase
    selected_template = form_data.get("template", "BBCA").upper()

    # Cek apakah template tersedia
    if selected_template not in template_map:
        return f"Template '{selected_template}' tidak dikenali.", 400

    generate_pdf(form_data, template_map[selected_template], output_path)

    return send_file(output_path, as_attachment=True)


if __name__ == '__main__':
    app.run(debug=True, port=8000)
