from reportlab.pdfgen import canvas
from reportlab.pdfbase import pdfmetrics
from reportlab.pdfbase.ttfonts import TTFont
from PyPDF2 import PdfReader, PdfWriter
from datetime import datetime, timedelta
import random
import os
import uuid
import tempfile

# Register custom fonts
# Path absolut ke direktori ini
BASE_DIR = os.path.dirname(os.path.abspath(__file__))
FONT_DIR = os.path.join(BASE_DIR, "../assets/fonts")

# Path ke file font
FONT_BOLD_PATH = os.path.join(FONT_DIR, "Poppins-Bold.ttf")
FONT_REGULAR_PATH = os.path.join(FONT_DIR, "Poppins-Regular.ttf")

# Register custom fonts
pdfmetrics.registerFont(TTFont("Poppins-Bold", FONT_BOLD_PATH))
pdfmetrics.registerFont(TTFont("Poppins-Regular", FONT_REGULAR_PATH))

if not os.path.isfile(FONT_BOLD_PATH) or not os.path.isfile(FONT_REGULAR_PATH):
    raise FileNotFoundError("Font Poppins tidak ditemukan di path yang ditentukan.")


def generate_random_bbca_data():
    rekening = ''.join(random.choices('1234567890', k=10))
    halaman = f"1/{random.randint(1, 50)}"
    now = datetime.now()
    periode = (now - timedelta(days=90)).strftime("%B %Y").upper()
    return rekening, halaman, periode

def generate_bbca_pdf(data, template_path, output_path):
    rekening, halaman, periode = generate_random_bbca_data()
    TEMP_DIR = os.path.join(os.path.dirname(os.path.abspath(__file__)), "../static/tmp")
    os.makedirs(TEMP_DIR, exist_ok=True)

    packet_path = os.path.join(TEMP_DIR, f"temp_overlay_{uuid.uuid4().hex}.pdf")

    c = canvas.Canvas(packet_path)

    # Judul tengah
    c.setFont("Helvetica-Bold", 17)
    # c.drawCentredString(300, 790, data["judul"])
    c.drawCentredString(300, 798, data.get("judul", ""))

    # Kanan atas
    c.setFont("Helvetica-Bold", 7)
    # ini nanti saja
    c.drawString(430, 755, data["norek"])
    c.drawString(430, 738, data["halaman"])
    c.drawString(430, 723, data["periode"])
    c.drawString(430, 706, data["matauang"])
    
    c.setFont("Helvetica", 7)

    # c.drawString(450, 725, f"HALAMAN : {halaman}")
    # c.drawString(450, 715, f"PERIODE : {periode}")
    # c.drawString(450, 705, "MATA UANG : IDR")

    # Kiri atas
    offset = 0
    offset2 = 0
    c.setFont("Helvetica", 7) 
    c.drawString(30, 755, data["nama"])
    c.drawString(30, 745, data["alamat1"])

    if data["alamat2"]:
        c.drawString(30, 735, data["alamat2"])
    else:
        offset += 10

    if data["kelurahan"]:
        c.drawString(30, 725 - offset, data["kelurahan"])
    else:
        offset2 += 10

    c.drawString(30, 715 - offset - offset2, data["kota"])
    c.setFont("Helvetica", 6)
    c.drawString(30, 705 - offset - offset2, data["kcp"])
    c.setFont("Helvetica", 7)
    c.drawString(30, 694 - offset - offset2, "INDONESIA")

    c.save()

    background = PdfReader(template_path)
    overlay = PdfReader(packet_path)
    writer = PdfWriter()

    page = background.pages[0]
    page.merge_page(overlay.pages[0])
    writer.add_page(page)

    with open(output_path, "wb") as f:
        writer.write(f)

def generate_aladin_pdf(data, template_path, output_path):
    TEMP_DIR = os.path.join(os.path.dirname(os.path.abspath(__file__)), "../static/tmp")
    os.makedirs(TEMP_DIR, exist_ok=True)

    packet_path = os.path.join(TEMP_DIR, f"temp_overlay_{uuid.uuid4().hex}.pdf")

    c = canvas.Canvas(packet_path)

    # Data untuk Aladin
    nama = data["nama"]
    alamat = " ".join(filter(None, [
        data["alamat1"],
        data["alamat2"],
        data["kelurahan"],
        data["kota"]
    ]))
    halaman = f"HALAMAN 1 DARI {random.randint(2, 9)}"

    now = datetime.now()
    awal = (now - timedelta(days=now.day)).replace(day=1)
    akhir = now.replace(day=1) - timedelta(days=1)
    periode = f"{awal.day:02d} - {akhir.day:02d} {akhir.strftime('%B %Y')}"

    total = f"{random.randint(1_000_000, 20_000_000):,}".replace(",", ".") + ",00"

    # Draw ke PDF
    c.setFont("Poppins-Bold", 8.63)
    # c.drawString(400, 770, halaman)

    c.setFont("Poppins-Bold", 8)
    c.drawString(28, 750, nama)
    c.setFont("Poppins-Regular", 8)
    c.drawString(28, 722, alamat)
    c.drawString(125, 655, "")
    c.drawString(125, 635, "")

    # c.setFont("Poppins-Bold", 8)
    # c.drawString(125, 615, total)

    c.save()

    background = PdfReader(template_path)
    overlay = PdfReader(packet_path)
    writer = PdfWriter()

    page = background.pages[0]
    page.merge_page(overlay.pages[0])
    writer.add_page(page)

    with open(output_path, "wb") as f:
        writer.write(f)

def generate_banksaqu_pdf(data, template_path, output_path):
    TEMP_DIR = os.path.join(os.path.dirname(os.path.abspath(__file__)), "../static/tmp")
    os.makedirs(TEMP_DIR, exist_ok=True)

    packet_path = os.path.join(TEMP_DIR, f"temp_overlay_{uuid.uuid4().hex}.pdf")

    c = canvas.Canvas(packet_path)

    nama = data["nama"]
    # alamat = " ".join(filter(None, [
    #     data["alamat1"],
    #     data["alamat2"],
    #     data["kelurahan"],
    #     data["kota"]
    # ]))
    halaman = f"HALAMAN 1 DARI {random.randint(2, 9)}"

    now = datetime.now()
    awal = (now - timedelta(days=now.day)).replace(day=1)
    akhir = now.replace(day=1) - timedelta(days=1)
    periode = f"{awal.day:02d} - {akhir.day:02d} {akhir.strftime('%B %Y')}"

    total = f"{random.randint(1_000_000, 20_000_000):,}".replace(",", ".") + ",00"

    # Draw ke PDF
    c.setFont("Poppins-Bold", 8.63)
    # c.drawString(400, 770, halaman)

    c.setFont("Poppins-Bold", 8)
    c.drawString(378, 780, nama)
    c.setFont("Poppins-Regular", 8)
    c.drawString(378, 755,  data["alamat1"])
    c.drawString(378, 740,  data["alamat2"])
    c.drawString(125, 635, "")

    # c.setFont("Poppins-Bold", 8)
    # c.drawString(125, 615, total)

    c.save()

    background = PdfReader(template_path)
    overlay = PdfReader(packet_path)
    writer = PdfWriter()

    page = background.pages[0]
    page.merge_page(overlay.pages[0])
    writer.add_page(page)

    with open(output_path, "wb") as f:
        writer.write(f)
    
    # Bersihkan file sementara
    if os.path.exists(packet_path):
        os.remove(packet_path)



def generate_pdf(data, template_path, output_path):
    if data.get("template") == "ALADIN":
        generate_aladin_pdf(data, template_path, output_path)
    elif data.get("template") == "BANKSAQU":
        generate_banksaqu_pdf(data, template_path, output_path)
    else:
        generate_bbca_pdf(data, template_path, output_path)
