import json
import random
import datetime
import io
from reportlab.pdfgen import canvas
from reportlab.lib.pagesizes import A4

def render_pdf(c, form_data, config):
    width, height = A4

    font_name = config.get("font", "Helvetica")
    body_size = config.get("body_size", 10)
    title_size = config.get("title_size", 14)

    for field in config["fields"]:
        name = field["name"]
        x = field["x"]
        y = field["y"]
        align = field.get("align", "left")

        if field["type"] == "manual":
            value = form_data.get(name, "")
        elif field["type"] == "fixed":
            value = field["value"]
        elif field["type"] == "auto":
            if name == "no_rekening":
                value = "".join([str(random.randint(0, 9)) for _ in range(12)])
            elif name == "halaman":
                value = f"1/{random.randint(2, 50)}"
            elif name == "periode":
                now = datetime.datetime.now()
                end_date = datetime.date(now.year, now.month, 1) - datetime.timedelta(days=1)
                start_month = end_date.month - 2 if end_date.month > 2 else end_date.month + 10
                start_year = end_date.year if end_date.month > 2 else end_date.year - 1
                start_date = datetime.date(start_year, start_month, 1)
                value = f"{start_date.strftime('%d %B %Y')} - {end_date.strftime('%d %B %Y')}"
            else:
                value = "AUTO"
        else:
            value = ""

        font_size = title_size if name == "judul" else body_size
        c.setFont(font_name, font_size)

        if align == "center":
            text_width = c.stringWidth(value, font_name, font_size)
            c.drawString(x - text_width / 2, y, value)
        else:
            c.drawString(x, y, value)

    c.showPage()
    c.save()

def generate_pdf(form_data, output_path, template_name):
    config_path = f"template_configs/{template_name}.json"
    with open(config_path, "r") as f:
        config = json.load(f)

    c = canvas.Canvas(output_path, pagesize=A4)
    render_pdf(c, form_data, config)

def generate_pdf_bytes(form_data, template_name):
    config_path = f"template_configs/{template_name}.json"
    with open(config_path, "r") as f:
        config = json.load(f)

    buffer = io.BytesIO()
    c = canvas.Canvas(buffer, pagesize=A4)
    render_pdf(c, form_data, config)

    buffer.seek(0)
    return buffer.read()
