<?php

namespace App\Http\Controllers;

use App\Models\Product;
// use App\Models\Sales;
use App\Models\Gatra;
use App\Models\DetailKlasifikasi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class GatraController extends Controller
{
    public function index()
    {
        $no = 1;
        $title = 'Data Gatra';
        $data = Gatra::orderBy('id')->get(); 
        return view('pages.data-gatra.index', compact('no', 'data', 'title')); 
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'gatra' => 'required|string|max:255',
            'bobot' => 'required|integer|min:1',
            'skor' => 'nullable|numeric|min:0',
        ]);

        // Set default skor jika tidak diisi
        $skor = $validated['skor'] ?? 0.00;
        
        // Hitung bobot_x_skor
        $bobotXSkor = $validated['bobot'] * $skor;

        Gatra::create([
            'gatra' => $validated['gatra'],
            'bobot' => $validated['bobot'],
            'skor' => $skor,
            'bobot_x_skor' => $bobotXSkor,
        ]);

        return redirect()->route('data-gatra.index')->with('success', 'Data gatra berhasil ditambahkan.');
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'nama' => 'required|string|max:255',
            'alamat' => 'required|string|max:255',
            'telepon' => 'required|integer',
        ]);

        $sales = Sales::findOrFail($id);
        $sales->update($validated);

        return redirect()->route('data-sales.index')->with('success', 'Data sales berhasil diperbarui.');
    }

    public function destroy($id) {  
        $data = Sales::find($id);

        $cek_produk = Product::where('id_sales', $id)->count();
        if ($cek_produk > 0) {
            return redirect()->back()->with('warning', 'Data ' . $data->nama . ' memiliki ' . $data->produk->count() . ' data produk terkait');
        } else {
            if ($data->delete()){
                return redirect()->back()->with('success', 'Data berhasil dihapus!');
            } else {
                return redirect()->back()->with('error', 'Gagal menghapus data');
            } 
        }  
    }

    public function refreshGatra()
    {
        try {
            // Ambil semua data gatra
            $gatraList = Gatra::all();
            
            foreach ($gatraList as $gatra) {
                // Mencocokkan berdasarkan ID gatra dengan nilai gatra di detail_klasifikasi
                // ID dari tabel gatra menjadi string di kolom gatra di detail_klasifikasi
                $gatraIdAsString = (string)$gatra->id;
                
                // Hitung rata-rata nilai_indeks untuk setiap gatra berdasarkan ID
                $averageScore = DetailKlasifikasi::where('gatra', $gatraIdAsString)
                    ->avg('nilai_indeks');
                
                // Jika tidak ada data detail klasifikasi untuk gatra ini, set skor ke 0
                $skor = $averageScore ?? 0.00;
                
                // Hitung bobot_x_skor
                $bobotXSkor = $gatra->bobot * $skor;
                
                // Update data gatra
                $gatra->update([
                    'skor' => round($skor, 2),
                    'bobot_x_skor' => round($bobotXSkor, 2),
                ]);
            }
            
            return redirect()->route('data-gatra.index')->with('success', 'Semua skor gatra berhasil diperbarui berdasarkan data klasifikasi.');
            
        } catch (\Exception $e) {
            return redirect()->route('data-gatra.index')->with('error', 'Terjadi kesalahan saat memperbarui skor gatra: ' . $e->getMessage());
        }
    }
}
