<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Product;
use App\Models\Inventory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Pelacakan;
use Carbon\Carbon;

class InventoryController extends Controller
{
    public function index(Request $request)
    {
        $no = 1;
        $title = 'Penjualan & Pembelian';

        // Inisialisasi query Inventory
        $query = Inventory::query();

        // Filter berdasarkan tanggal jika ada
        if ($request->has('tanggal') && $request->tanggal) {
            $query->whereDate('created_at', $request->tanggal);
        }

        // Filter berdasarkan jenis (barang masuk/keluar) jika ada
        if ($request->has('jenis') && $request->jenis) {
            $query->where('jenis', $request->jenis);
        }

        // Ambil data sesuai filter
        // $data = $query->latest()->get();
        $data = $query->with(['pelacakan.customer', 'produk.sales'])->latest()->get();


        // Tambahkan properti pelanggan/sales sesuai jenis
        $data->transform(function ($item) {
            if ($item->jenis === 'barang keluar') {
                $pelacakan = $item->pelacakan;
                // echo "cek pelacakan";
                // echo $pelacakan;
                // exit();
                if ($pelacakan && $pelacakan->customer) {
                    $item->id_pelanggan = $pelacakan->customer->id ?? null;
                    $item->nama_pelanggan = $pelacakan->customer->nama_pelanggan ?? '';
                } else {
                    $item->id_pelanggan = null;
                    $item->nama_pelanggan = '';
                }
                $item->id_sales = '';
                $item->nama_sales = '';
            } elseif ($item->jenis === 'barang masuk') {
                // Ambil sales dari produk
                // $pelacakan = $item;
                // $pelacakan = $item->pelacakan;
                // echo "cek pelacakan";
                // echo $pelacakan;
                // exit();

                $sales = $item->produk && $item->produk->sales ? $item->produk->sales : null;
                $item->id_sales = $sales->id ?? '';
                $item->nama_sales = $sales->nama ?? '';
                // Pelanggan kosong
                $item->id_pelanggan = null;
                $item->nama_pelanggan = '';
            } else {
                // Default kosong semua
                $item->id_pelanggan = null;
                $item->nama_pelanggan = '';
                $item->id_sales = '';
                $item->nama_sales = '';
            }
            return $item;
        });

        // Untuk debug
        // echo $data;
        // exit();


        // return view('pages.penjualan.index', compact('no', 'title', 'data'));
        return view('pages.inventory.index', compact('no', 'title', 'data'));



        // $no = 1;
        // $title = 'Inventory';

        // // Inisialisasi query Inventory
        // $query = Inventory::query();

        // // Filter berdasarkan tanggal jika ada
        // if ($request->has('tanggal') && $request->tanggal) {
        //     $query->whereDate('created_at', $request->tanggal);
        // }

        // // Filter berdasarkan jenis (barang masuk/keluar) jika ada
        // if ($request->has('jenis') && $request->jenis) {
        //     $query->where('jenis', $request->jenis);
        // }

        // // Ambil data sesuai filter
        // $data = $query->latest()->get();

        // return view('pages.inventory.index', compact('no', 'title', 'data'));
    }

    public function create()
    {
        $title = 'Inventory';
        $produk = Product::all();
        return view('pages.inventory.create', compact('title', 'produk'));
    }

    public function store(Request $request)
    {
        // dd($request);
        $request->validate([
            'produk' => 'required',
            'jumlah_barang' => 'required',
            'jenis' => 'required',
        ]);

        $jenis = $request->jenis;

        $aliran_barang = new Inventory();
        $aliran_barang->jenis = $jenis;
        $aliran_barang->jumlah_barang = $request->jumlah_barang;
        $aliran_barang->pembayaran = $request->total_harga;
        $aliran_barang->id_produk = $request->produk;
        $aliran_barang->id_karyawan = auth()->user()->id;
        $aliran_barang->pesan = $request->pesan;

        $produk = Product::findOrFail($request->produk);


        if ($request->jenis === 'barang masuk') {
            if ($aliran_barang->save()) {
                $produk->increment('stok_produk', $request->jumlah_barang);
                return redirect()->route('inventory.index')->with('success', 'Data berhasil disimpan!');
            } else {
                return redirect()->route('inventory.index')->with('error', 'Gagal menyimpan data');
            }
        } else {
            if ($produk->stok_produk >= $request->jumlah_barang) {
                if ($aliran_barang->save()) {
                    $produk->decrement('stok_produk', $request->jumlah_barang);
                    return redirect()->route('inventory.index')->with('success', 'Data berhasil disimpan!');
                } else {
                    return redirect()->route('inventory.index')->with('error', 'Gagal menyimpan data');
                }
            } else {
                return redirect()->back()->with('error', 'Stok tidak mencukupi untuk produk ' . $produk->nama_produk . ' !');
            }
        }
    }

    public function laporan()
    {
        $title = 'Laporan';
        $data = Inventory::select(
            DB::raw('YEAR(created_at) as tahun'),
            DB::raw('MONTH(created_at) as bulan'),
            DB::raw('COUNT(*) as jumlah')
        )->groupBy('tahun', 'bulan')->get();
        return view('pages.inventory.laporan', compact('title', 'data'));
    }

    public function unduh_laporan_back($tahun, $bulan)
    {
        // $data = Inventory::whereYear('created_at', $tahun)
        //     ->whereMonth('created_at', $bulan)
        //     ->get();


        // $tahun = $request->input('tahun');
        // $bulan = $request->input('bulan');

        if (!$tahun || !$bulan) {
            return redirect()->back()->with('error', 'Tahun dan bulan harus dipilih.');
        }

        $data = Pelacakan::with(['products', 'customer', 'staff'])
            ->whereYear('created_at', $tahun)
            ->whereMonth('created_at', $bulan)
            ->get();

        $kurir = []; // jika perlu
        $no = 1;

        // return view('pages.pelacakan.unduh_per_bulan', [
        //     'orders' => $orders,
        //     'kurir' => $kurir,
        //     'no' => $no,
        //     'selectedBulan' => $bulan,
        //     'selectedTahun' => $tahun,
        //     'nama_bulan' => Carbon::create()->month($bulan)->translatedFormat('F'),
        // ]);

        return view('pages.inventory.download', compact('data', 'tahun', 'bulan'));
    }


    public function unduh_laporan($start_date, $end_date)
    {

        if (!$start_date || !$end_date) {
            return redirect()->back()->with('error', 'Start Date dan End Date harus dipilih.');
        }

        $data = Pelacakan::with(['products', 'customer', 'staff'])
            ->whereBetween('created_at', [
                $start_date . ' 00:00:00',
                $end_date . ' 23:59:59'
            ])
            ->get();

        $kurir = []; // jika perlu
        $no = 1;


        return view('pages.inventory.download', compact('data', 'start_date', 'end_date'));
    }

    public function unduh_laporan_status($start_date, $end_date, $status)
    {

        if (!$start_date || !$end_date) {
            return redirect()->back()->with('error', 'Start Date dan End Date harus dipilih.');
        }

        $data = Pelacakan::with(['products', 'customer', 'staff'])
            ->whereBetween('created_at', [
                $start_date . ' 00:00:00',
                $end_date . ' 23:59:59'
            ])
            ->where('status', $status)
            ->get();

        $kurir = []; // jika perlu
        $no = 1;


        return view('pages.inventory.download', compact('data', 'start_date', 'end_date'));
    }

    //unduh_laporan_cara
    public function unduh_laporan_cara($start_date, $end_date, $cara)
    {

        if (!$start_date || !$end_date) {
            return redirect()->back()->with('error', 'Start Date dan End Date harus dipilih.');
        }

        $data = Pelacakan::with(['products', 'customer', 'staff'])
            ->whereBetween('created_at', [
                $start_date . ' 00:00:00',
                $end_date . ' 23:59:59'
            ])
            ->where('cara_bayar', $cara)
            ->get();

        $kurir = []; // jika perlu
        $no = 1;


        return view('pages.inventory.download', compact('data', 'start_date', 'end_date'));
    }

    public function unduh_laporan_produk($start_date, $end_date, $produk)
    {

        if (!$start_date || !$end_date) {
            return redirect()->back()->with('error', 'Start Date dan End Date harus dipilih.');
        }

        $data = Pelacakan::with(['products', 'customer', 'staff'])
            ->whereBetween('created_at', [
                $start_date . ' 00:00:00',
                $end_date . ' 23:59:59'
            ])
            ->whereHas('products', function ($query) use ($produk) {
                $query->where('id', $produk);
            })
            ->get();

        $kurir = []; // jika perlu
        $no = 1;
        
        return view('pages.inventory.download', compact('data', 'start_date', 'end_date'));
    }



    public function unduh_laporan_all()
    {



        $data = Pelacakan::with(['products', 'customer', 'staff'])
            // ->whereBetween('created_at', [
            //     $start_date . ' 00:00:00',
            //     $end_date . ' 23:59:59'
            // ])
            ->get();

        $kurir = []; // jika perlu
        $no = 1;
        $start_date = "";
        $end_date = "";


        return view('pages.inventory.download', compact('data', 'start_date', 'end_date'));
    }

    public function unduh_laporan_pembelian($start_date, $end_date)
    {
        if (!$start_date || !$end_date) {
            return redirect()->back()->with('error', 'Start Date dan End Date harus dipilih.');
        }

        $data = Inventory::whereBetween('created_at', [
            $start_date . ' 00:00:00',
            $end_date . ' 23:59:59'
        ])
            ->with(['pelacakan.customer', 'produk.sales'])
            ->latest()
            ->get();

        // Tambahkan properti pelanggan/sales sesuai jenis
        $data->transform(function ($item) {
            if ($item->jenis === 'barang keluar') {
                $pelacakan = $item->pelacakan;
                if ($pelacakan && $pelacakan->customer) {
                    $item->id_pelanggan = $pelacakan->customer->id ?? null;
                    $item->nama_pelanggan = $pelacakan->customer->nama_pelanggan ?? '';
                } else {
                    $item->id_pelanggan = null;
                    $item->nama_pelanggan = '';
                }
                $item->id_sales = '';
                $item->nama_sales = '';
            } elseif ($item->jenis === 'barang masuk') {
                $sales = $item->produk && $item->produk->sales ? $item->produk->sales : null;
                $item->id_sales = $sales->id ?? '';
                $item->nama_sales = $sales->nama ?? '';
                $item->id_pelanggan = null;
                $item->nama_pelanggan = '';
            } else {
                $item->id_pelanggan = null;
                $item->nama_pelanggan = '';
                $item->id_sales = '';
                $item->nama_sales = '';
            }
            return $item;
        });

        $kurir = []; // jika perlu
        $no = 1;

        return view('pages.inventory.download_pembelian', compact('data', 'start_date', 'end_date'));
    }

    public function unduh_laporan_pembelian_back($start_date, $end_date)
    {
        // $data = Inventory::whereYear('created_at', $tahun)
        //     ->whereMonth('created_at', $bulan)
        //     ->get();


        if (!$start_date || !$end_date) {
            return redirect()->back()->with('error', 'Start Date dan End Date harus dipilih.');
        }

        $data = collect(); // default kosong

        if ($selectedTahun && $selectedBulan) {

            $query = Inventory::query();
            $query->whereYear('created_at', $selectedTahun)
                ->whereMonth('created_at', $selectedBulan);
            $data = $query->with(['pelacakan.customer', 'produk.sales'])->latest()->get();


            //->whereMonth('created_at', $selectedBulan)


            // Tambahkan properti pelanggan/sales sesuai jenis
            $data->transform(function ($item) {
                if ($item->jenis === 'barang keluar') {
                    $pelacakan = $item->pelacakan;
                    // echo "cek pelacakan";
                    // echo $pelacakan;
                    // exit();
                    if ($pelacakan && $pelacakan->customer) {
                        $item->id_pelanggan = $pelacakan->customer->id ?? null;
                        $item->nama_pelanggan = $pelacakan->customer->nama_pelanggan ?? '';
                    } else {
                        $item->id_pelanggan = null;
                        $item->nama_pelanggan = '';
                    }
                    $item->id_sales = '';
                    $item->nama_sales = '';
                } elseif ($item->jenis === 'barang masuk') {
                    // Ambil sales dari produk
                    // $pelacakan = $item;
                    // $pelacakan = $item->pelacakan;
                    // echo "cek pelacakan";
                    // echo $pelacakan;
                    // exit();

                    $sales = $item->produk && $item->produk->sales ? $item->produk->sales : null;
                    $item->id_sales = $sales->id ?? '';
                    $item->nama_sales = $sales->nama ?? '';
                    // Pelanggan kosong
                    $item->id_pelanggan = null;
                    $item->nama_pelanggan = '';
                } else {
                    // Default kosong semua
                    $item->id_pelanggan = null;
                    $item->nama_pelanggan = '';
                    $item->id_sales = '';
                    $item->nama_sales = '';
                }
                return $item;
            });
        }

        $kurir = []; // jika perlu
        $no = 1;

        return view('pages.inventory.download_pembelian', compact('data', 'tahun', 'bulan'));
    }
}
