<?php

namespace App\Http\Controllers;

use App\Models\User;
use Carbon\Carbon;
use App\Models\Product;
use App\Models\Inventory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Pelacakan;

class LaporanTokoController extends Controller
{

    public function index(Request $request)
    {


        $no = 1;
        $title = 'Laporan Toko';


        // return view('pages.laporan_toko.index', compact('no', 'title', 'data'));
        return view('pages.laporan_toko.index', compact('no', 'title'));
    }

    //penjualan_per_bulan
    public function penjualan_per_bulan(Request $request)
    {
        $no = 1;
        $title = 'Penjualan Per Bulan';

        // Ambil data bulan-tahun unik dari pelacakans
        $bulanUnik = DB::table('pelacakans')
            ->selectRaw('YEAR(created_at) as tahun, MONTH(created_at) as bulan')
            ->distinct()
            ->orderByDesc('tahun')
            ->orderByDesc('bulan')
            ->get()
            ->map(function ($item) {
                $item->nama_bulan = Carbon::create()->month($item->bulan)->locale('id')->translatedFormat('F');
                return $item;
            });

        // Jika user klik salah satu bulan
        $selectedTahun = $request->input('tahun');
        $selectedBulan = $request->input('bulan');
        $orders = collect(); // default kosong

        if ($selectedTahun && $selectedBulan) {
            $query = Pelacakan::query()
                ->whereYear('created_at', $selectedTahun)
                ->whereMonth('created_at', $selectedBulan);

            $orders_admin = $query->with(['customer', 'products', 'kurir', 'staff'])->latest()->get();
            $orders_kurir = $query->with(['customer', 'products', 'kurir', 'staff'])->where('status', '!=', 'dikemas')->latest()->get();
            $orders = auth()->user()->role == 'Kurir' ? $orders_kurir : $orders_admin;
        }

        $kurir = User::where('role', 'Kurir')->get();

        return view('pages.laporan_toko.penjualan_per_bulan', compact('no', 'title', 'bulanUnik', 'orders', 'kurir', 'selectedTahun', 'selectedBulan'));
    }


    public function penjualan_per_produk(Request $request)
    {
        $no = 1;
        $title = 'Penjualan Per Produk';

        // Query produk terlaris (hanya transaksi status selesai)
        $produkTerlaris = DB::table('order_details')
            ->join('products', 'order_details.product_id', '=', 'products.id')
            ->join('pelacakans', 'order_details.pelacakan_id', '=', 'pelacakans.id')
            ->select(
                'products.id',
                'products.nama_produk',
                DB::raw('SUM(order_details.quantity) as total_terjual'),
                DB::raw('SUM(order_details.quantity * order_details.harga_produk) as total_penjualan')
            )
            ->where('pelacakans.status', 'selesai')
            ->groupBy('products.id', 'products.nama_produk')
            ->orderByDesc('total_terjual')
            ->get();

        $selectedProdukId = $request->input('id_produk');
        $orders = collect();

        $start_date = $request->start_date;
        $end_date = $request->end_date;

        if ($selectedProdukId) {
            $ordersQuery = \App\Models\Pelacakan::whereHas('products', function ($q) use ($selectedProdukId) {
                $q->where('products.id', $selectedProdukId);
            });

            // Filter by date range jika ada
            if ($start_date && $end_date) {
                $ordersQuery->whereBetween('created_at', [
                    $start_date . ' 00:00:00',
                    $end_date . ' 23:59:59'
                ]);
            } elseif ($start_date) {
                $ordersQuery->whereDate('created_at', '>=', $start_date);
            } elseif ($end_date) {
                $ordersQuery->whereDate('created_at', '<=', $end_date);
            }

            $orders = $ordersQuery
                ->with(['customer', 'products', 'kurir', 'staff'])
                ->latest()
                ->get();
        }

        $kurir = \App\Models\User::where('role', 'Kurir')->get();

        return view('pages.laporan_toko.penjualan_per_produk', compact(
            'no',
            'title',
            'produkTerlaris',
            'orders',
            'kurir',
            'selectedProdukId',
            'start_date',
            'end_date'
        ));
    }

    public function penjualan_per_produk1(Request $request)
    {
        $no = 1;
        $title = 'Penjualan Per Produk';

        // Query produk terlaris (hanya transaksi status selesai)
        $produkTerlaris = DB::table('order_details')
            ->join('products', 'order_details.product_id', '=', 'products.id')
            ->join('pelacakans', 'order_details.pelacakan_id', '=', 'pelacakans.id')
            ->select(
                'products.id',
                'products.nama_produk',
                DB::raw('SUM(order_details.quantity) as total_terjual'),
                DB::raw('SUM(order_details.quantity * order_details.harga_produk) as total_penjualan')
            )
            ->where('pelacakans.status', 'selesai')
            ->groupBy('products.id', 'products.nama_produk')
            ->orderByDesc('total_terjual')
            ->get();

        // echo $produkTerlaris;
        // exit();


        // $no = 1;
        // $title = 'Penjualan Per Produk';

        // // Ambil data cara_bayar unik dari pelacakans
        // $caraBayarUnik = DB::table('pelacakans')
        //     ->select('cara_bayar')
        //     ->whereNotNull('cara_bayar')
        //     ->distinct()
        //     ->pluck('cara_bayar');

        // $tanggal = $request->tanggal;
        // $selectedCaraBayar = $request->input('cara_bayar');
        // $orders = collect();

        // if ($selectedCaraBayar) {
        //     $query = Pelacakan::query()
        //         ->where('cara_bayar', $selectedCaraBayar);

        //     if ($tanggal) {
        //         $query->whereDate('created_at', $tanggal);
        //     }

        //     $orders_admin = $query->with(['customer', 'products', 'kurir', 'staff'])->latest()->get();
        //     $orders_kurir = $query->with(['customer', 'products', 'kurir', 'staff'])->where('status', '!=', 'dikemas')->latest()->get();
        //     $orders = auth()->user()->role == 'Kurir' ? $orders_kurir : $orders_admin;
        // }

        // $kurir = User::where('role', 'Kurir')->get();

        // return view('pages.laporan_toko.penjualan_per_cara_bayar', compact('no', 'title', 'caraBayarUnik', 'orders', 'kurir', 'selectedCaraBayar'));
        return view('pages.laporan_toko.penjualan_per_produk', compact('no', 'title', 'produkTerlaris'));
    }


    public function penjualan_all(Request $request)
    {
        $no = 1;
        $title = 'Laporan Penjualan ';

        // Ambil semua status unik dari pelacakans
        $statusUnik = DB::table('pelacakans')
            ->select('status')
            ->distinct()
            ->orderBy('status', 'asc')
            ->pluck('status');

        $start_date = $request->start_date;
        $end_date = $request->end_date;

        $orders = collect();

        $query = Pelacakan::query();

        if ($start_date && $end_date) {
            $query->whereBetween('created_at', [
                $start_date . ' 00:00:00',
                $end_date . ' 23:59:59'
            ]);
        } elseif ($start_date) {
            $query->whereDate('created_at', '>=', $start_date);
        } elseif ($end_date) {
            $query->whereDate('created_at', '<=', $end_date);
        }

        $orders_admin = $query->with(['customer', 'products', 'kurir', 'staff'])->latest()->get();
        $orders_kurir = $query->with(['customer', 'products', 'kurir', 'staff'])->where('status', '!=', 'dikemas')->latest()->get();
        $orders = auth()->user()->role == 'Kurir' ? $orders_kurir : $orders_admin;

        $kurir = User::where('role', 'Kurir')->get();

        return view('pages.laporan_toko.penjualan_all', compact('no', 'title', 'statusUnik', 'orders', 'kurir', 'start_date', 'end_date'));
    }


    public function penjualan_per_status(Request $request)
    {
        $no = 1;
        $title = 'Penjualan Per Status';

        // Ambil semua status unik dari pelacakans
        $statusUnik = DB::table('pelacakans')
            ->select('status')
            ->distinct()
            ->orderBy('status', 'asc')
            ->pluck('status');

        // $tanggal = $request->tanggal;

        $start_date = $request->start_date;
        $end_date = $request->end_date;

        // Ambil status yang dipilih dari request
        $selectedStatus = $request->input('status');
        $orders = collect();

        if ($selectedStatus) {
            $query = Pelacakan::query()
                ->where('status', $selectedStatus);

            if ($start_date && $end_date) {
                $query->whereBetween('created_at', [
                    $start_date . ' 00:00:00',
                    $end_date . ' 23:59:59'
                ]);
            } elseif ($start_date) {
                $query->whereDate('created_at', '>=', $start_date);
            } elseif ($end_date) {
                $query->whereDate('created_at', '<=', $end_date);
            }

            $orders_admin = $query->with(['customer', 'products', 'kurir', 'staff'])->latest()->get();
            $orders_kurir = $query->with(['customer', 'products', 'kurir', 'staff'])->where('status', '!=', 'dikemas')->latest()->get();
            $orders = auth()->user()->role == 'Kurir' ? $orders_kurir : $orders_admin;
        }




        $kurir = User::where('role', 'Kurir')->get();

        return view('pages.laporan_toko.penjualan_per_status', compact('no', 'title', 'statusUnik', 'orders', 'kurir', 'selectedStatus', 'start_date', 'end_date'));
    }

    public function penjualan_per_cara_bayar(Request $request)
    {
        $no = 1;
        $title = 'Penjualan Per Cara Bayar';

        // Ambil data cara_bayar unik dari pelacakans
        $caraBayarUnik = DB::table('pelacakans')
            ->select('cara_bayar')
            ->whereNotNull('cara_bayar')
            ->distinct()
            ->pluck('cara_bayar');

        // $tanggal = $request->tanggal;
        $start_date = $request->start_date;
        $end_date = $request->end_date;

        $selectedCaraBayar = $request->input('cara_bayar');
        $orders = collect();

        if ($selectedCaraBayar) {
            $query = Pelacakan::query()
                ->where('cara_bayar', $selectedCaraBayar);

            if ($start_date && $end_date) {
                $query->whereBetween('created_at', [
                    $start_date . ' 00:00:00',
                    $end_date . ' 23:59:59'
                ]);
            } elseif ($start_date) {
                $query->whereDate('created_at', '>=', $start_date);
            } elseif ($end_date) {
                $query->whereDate('created_at', '<=', $end_date);
            }


            $orders_admin = $query->with(['customer', 'products', 'kurir', 'staff'])->latest()->get();
            $orders_kurir = $query->with(['customer', 'products', 'kurir', 'staff'])->where('status', '!=', 'dikemas')->latest()->get();
            $orders = auth()->user()->role == 'Kurir' ? $orders_kurir : $orders_admin;
        }

        $kurir = User::where('role', 'Kurir')->get();

        return view('pages.laporan_toko.penjualan_per_cara_bayar', compact('no', 'title', 'caraBayarUnik', 'orders', 'kurir', 'selectedCaraBayar', 'start_date', 'end_date'));
    }





    //pembeilan per_bulan sama seperti inventory
    public function pembelian_per_bulan(Request $request)
    {
        $no = 1;
        $title = 'Pembelian Per Bulan';

        // // Ambil data bulan-tahun unik dari inventory
        $bulanUnik = DB::table('inventories')
            ->selectRaw('YEAR(created_at) as tahun, MONTH(created_at) as bulan')
            ->distinct()
            ->orderByDesc('tahun')
            ->orderByDesc('bulan')
            ->get()
            ->map(function ($item) {
                $item->nama_bulan = Carbon::create()->month($item->bulan)->locale('id')->translatedFormat('F');
                return $item;
            });

        // // Jika user klik salah satu bulan
        $selectedTahun = $request->input('tahun');
        $selectedBulan = $request->input('bulan');
        $data = collect(); // default kosong

        if ($selectedTahun && $selectedBulan) {
            // $data = Inventory::whereYear('created_at', $selectedTahun)
            //     ->whereMonth('created_at', $selectedBulan)
            //     ->with(['produk'])
            //     ->latest()
            //     ->get();
            $query = Inventory::query();
            $query->whereYear('created_at', $selectedTahun)
                ->whereMonth('created_at', $selectedBulan);
            $data = $query->with(['pelacakan.customer', 'produk.sales'])->latest()->get();


            //->whereMonth('created_at', $selectedBulan)


            // Tambahkan properti pelanggan/sales sesuai jenis
            $data->transform(function ($item) {
                if ($item->jenis === 'barang keluar') {
                    $pelacakan = $item->pelacakan;
                    // echo "cek pelacakan";
                    // echo $pelacakan;
                    // exit();
                    if ($pelacakan && $pelacakan->customer) {
                        $item->id_pelanggan = $pelacakan->customer->id ?? null;
                        $item->nama_pelanggan = $pelacakan->customer->nama_pelanggan ?? '';
                    } else {
                        $item->id_pelanggan = null;
                        $item->nama_pelanggan = '';
                    }
                    $item->id_sales = '';
                    $item->nama_sales = '';
                } elseif ($item->jenis === 'barang masuk') {
                    // Ambil sales dari produk
                    // $pelacakan = $item;
                    // $pelacakan = $item->pelacakan;
                    // echo "cek pelacakan";
                    // echo $pelacakan;
                    // exit();

                    $sales = $item->produk && $item->produk->sales ? $item->produk->sales : null;
                    $item->id_sales = $sales->id ?? '';
                    $item->nama_sales = $sales->nama ?? '';
                    // Pelanggan kosong
                    $item->id_pelanggan = null;
                    $item->nama_pelanggan = '';
                } else {
                    // Default kosong semua
                    $item->id_pelanggan = null;
                    $item->nama_pelanggan = '';
                    $item->id_sales = '';
                    $item->nama_sales = '';
                }
                return $item;
            });
        }

        // //return view('pages.inventory.index', compact('no', 'title', 'data'));
        // return view('pages.laporan_toko.pembelian_per_bulan', compact('no', 'title', 'bulanUnik', 'data', 'selectedTahun', 'selectedBulan'));



        // Inisialisasi query Inventory
        // $query = Inventory::query();

        // Filter berdasarkan tanggal jika ada
        if ($request->has('tanggal') && $request->tanggal) {
            $query->whereDate('created_at', $request->tanggal);
        }

        // Filter berdasarkan jenis (barang masuk/keluar) jika ada
        if ($request->has('jenis') && $request->jenis) {
            $query->where('jenis', $request->jenis);
        }

        // Ambil data sesuai filter
        // $data = $query->latest()->get();


        // Untuk debug
        // echo $data;
        // exit();

        // return view('pages.laporan_toko.index', compact('no', 'title', 'data'));
        // return view('pages.laporan_toko.pembelian_per_bulan', compact('no', 'title', 'data'));
        return view('pages.laporan_toko.pembelian_per_bulan', compact('no', 'title', 'bulanUnik', 'data', 'selectedTahun', 'selectedBulan'));
    }



    public function pembelian_all(Request $request)
    {
        $no = 1;
        $title = 'Pembelian';

        // Ambil data bulan-tahun unik dari inventory (opsional, bisa dihapus jika tidak dipakai)
        $bulanUnik = DB::table('inventories')
            ->selectRaw('YEAR(created_at) as tahun, MONTH(created_at) as bulan')
            ->distinct()
            ->orderByDesc('tahun')
            ->orderByDesc('bulan')
            ->get()
            ->map(function ($item) {
                $item->nama_bulan = Carbon::create()->month($item->bulan)->locale('id')->translatedFormat('F');
                return $item;
            });

        $start_date = $request->input('start_date');
        $end_date = $request->input('end_date');
        $data = collect(); // default kosong

        $query = Inventory::query();

        // Filter antara tanggal jika ada
        if ($start_date && $end_date) {
            $query->whereBetween('created_at', [
                $start_date . ' 00:00:00',
                $end_date . ' 23:59:59'
            ]);
        } elseif ($start_date) {
            $query->whereDate('created_at', '>=', $start_date);
        } elseif ($end_date) {
            $query->whereDate('created_at', '<=', $end_date);
        }

        // Filter berdasarkan tanggal harian jika ada (opsional, bisa dihapus jika tidak dipakai)
        if ($request->has('tanggal') && $request->tanggal) {
            $query->whereDate('created_at', $request->tanggal);
        }

        // Filter berdasarkan jenis (barang masuk/keluar) jika ada
        if ($request->has('jenis') && $request->jenis) {
            $query->where('jenis', $request->jenis);
        }

        $data = $query->with(['pelacakan.customer', 'produk.sales'])->latest()->get();

        // Tambahkan properti pelanggan/sales sesuai jenis
        $data->transform(function ($item) {
            if ($item->jenis === 'barang keluar') {
                $pelacakan = $item->pelacakan;
                if ($pelacakan && $pelacakan->customer) {
                    $item->id_pelanggan = $pelacakan->customer->id ?? null;
                    $item->nama_pelanggan = $pelacakan->customer->nama_pelanggan ?? '';
                } else {
                    $item->id_pelanggan = null;
                    $item->nama_pelanggan = '';
                }
                $item->id_sales = '';
                $item->nama_sales = '';
            } elseif ($item->jenis === 'barang masuk') {
                $sales = $item->produk && $item->produk->sales ? $item->produk->sales : null;
                $item->id_sales = $sales->id ?? '';
                $item->nama_sales = $sales->nama ?? '';
                $item->id_pelanggan = null;
                $item->nama_pelanggan = '';
            } else {
                $item->id_pelanggan = null;
                $item->nama_pelanggan = '';
                $item->id_sales = '';
                $item->nama_sales = '';
            }
            return $item;
        });

        return view('pages.laporan_toko.pembelian_all', compact('no', 'title', 'bulanUnik', 'data', 'start_date', 'end_date'));
    }



    public function create()
    {
        $title = 'Inventory';
        $produk = Product::all();
        return view('pages.inventory.create', compact('title', 'produk'));
    }

    public function store(Request $request)
    {
        // dd($request);
        $request->validate([
            'produk' => 'required',
            'jumlah_barang' => 'required',
            'jenis' => 'required',
        ]);

        $jenis = $request->jenis;

        $aliran_barang = new Inventory();
        $aliran_barang->jenis = $jenis;
        $aliran_barang->jumlah_barang = $request->jumlah_barang;
        $aliran_barang->pembayaran = $request->total_harga;
        $aliran_barang->id_produk = $request->produk;
        $aliran_barang->id_karyawan = auth()->user()->id;
        $aliran_barang->pesan = $request->pesan;

        $produk = Product::findOrFail($request->produk);


        if ($request->jenis === 'barang masuk') {
            if ($aliran_barang->save()) {
                $produk->increment('stok_produk', $request->jumlah_barang);
                return redirect()->route('inventory.index')->with('success', 'Data berhasil disimpan!');
            } else {
                return redirect()->route('inventory.index')->with('error', 'Gagal menyimpan data');
            }
        } else {
            if ($produk->stok_produk >= $request->jumlah_barang) {
                if ($aliran_barang->save()) {
                    $produk->decrement('stok_produk', $request->jumlah_barang);
                    return redirect()->route('inventory.index')->with('success', 'Data berhasil disimpan!');
                } else {
                    return redirect()->route('inventory.index')->with('error', 'Gagal menyimpan data');
                }
            } else {
                return redirect()->back()->with('error', 'Stok tidak mencukupi untuk produk ' . $produk->nama_produk . ' !');
            }
        }
    }

    public function laporan()
    {
        $title = 'Laporan';
        $data = Inventory::select(
            DB::raw('YEAR(created_at) as tahun'),
            DB::raw('MONTH(created_at) as bulan'),
            DB::raw('COUNT(*) as jumlah')
        )->groupBy('tahun', 'bulan')->get();
        return view('pages.inventory.laporan', compact('title', 'data'));
    }

    public function unduh_laporan($tahun, $bulan)
    {
        $data = Inventory::whereYear('created_at', $tahun)
            ->whereMonth('created_at', $bulan)
            ->get();

        return view('pages.inventory.download', compact('data', 'tahun', 'bulan'));
    }
}
