<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CicilanHistory extends Model
{
    use HasFactory;

    protected $fillable = [
        'pelacakan_id',
        'pelanggan_id',
        'jumlah_cicilan',
        'metode_pembayaran',
        'bukti',
    ];

    public function pelacakan()
    {
        return $this->belongsTo(Pelacakan::class, 'pelacakan_id');
    }

    public function pelanggan()
    {
        return $this->belongsTo(Pelanggan::class, 'pelanggan_id');
    }
}
