<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gatra extends Model
{
    use HasFactory;

    protected $table = 'gatra';

    protected $fillable = [
        'gatra',
        'bobot',
        'skor',
        'bobot_x_skor',
    ];

    protected $casts = [
        'bobot' => 'integer',
        'skor' => 'decimal:2',
        'bobot_x_skor' => 'decimal:2',
    ];

    // Accessor untuk menghitung bobot_x_skor otomatis
    public function getBobotXSkorAttribute($value)
    {
        return $value ?: ($this->bobot * $this->skor);
    }

    // Mutator untuk mengatur bobot_x_skor secara otomatis saat menyimpan
    public function setBobotXSkorAttribute($value)
    {
        $this->attributes['bobot_x_skor'] = $this->bobot * $this->skor;
    }
}
