<?php

namespace App\Models;

use App\Models\User;
use App\Models\Product;
use App\Models\Pelacakan;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Inventory extends Model
{
    use HasFactory;

    protected $table = 'inventories';
    protected $guarded = ['id'];

    public function produk()
    {
        return $this->belongsTo(Product::class, 'id_produk')->withTrashed();
    }

    public function staff()
    {
        return $this->belongsTo(User::class, 'id_karyawan');
    }

    // public function pelacakan()
    // {
    //     return $this->hasOne(Pelacakan::class, 'id_inventory');
    // }

    public function pelacakan()
    {
        return $this->belongsTo(Pelacakan::class, 'id_pelacakan');
    }
}
