<?php

namespace App\Models;

use App\Models\User;
use App\Models\Product;
use App\Models\Inventory;
use App\Models\Pelanggan;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Pelacakan extends Model
{
    use HasFactory;

    protected $table = 'pelacakans';
    protected $guarded = ['id'];

    public function produk()
    {
        return $this->belongsTo(Product::class, 'id_produk');
    }

    public function staff()
    {
        return $this->belongsTo(User::class, 'id_karyawan');
    }

    public function kurir()
    {
        return $this->belongsTo(User::class, 'id_kurir');
    }

    public function customer()
    {
        return $this->belongsTo(Pelanggan::class, 'id_customer');
    }

    // Uncomment if you want to use the relationship with Inventory
    // This relationship assumes that each Pelacakan can have one Inventory
    // If you want to keep the relationship, uncomment the following method


    public function inventory()
    {
        return $this->belongsTo(Inventory::class, 'id_inventory');
    }

    public function inventories()
    {
        return $this->hasMany(Inventory::class, 'id_pelacakan');
    }

    public function products()
    {
        return $this->belongsToMany(Product::class, 'order_details', 'pelacakan_id', 'product_id')
            ->withPivot(['harga_produk', 'quantity'])
            ->withTimestamps()
            ->withTrashed();
    }
}
