<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pelanggan extends Model
{
    use HasFactory;

    protected $table = 'pelanggans';

    protected $guarded = ['id'];


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function produk()
    {
        return $this->hasMany(Product::class, 'id_pelanggan');
    }
    public function pelacakan()
    {
        return $this->hasMany(Pelacakan::class, 'id_customer');
    }
    public function sales()
    {
        return $this->hasMany(Sales::class, 'id_pelanggan');
    }
    public function inventory()
    {
        return $this->hasMany(Inventory::class, 'id_pelanggan');
    }
}
