<?php

namespace App\Models;

use App\Models\Sales;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'products';

    protected $fillable = [
        'nama_produk',
        'foto_produk', 
        'harga_produk',
        'stok_produk',
        'best_seller',
        'id_sales'
    ];

    public function sales()
    {
        return $this->belongsTo(Sales::class, 'id_sales');
    }
}
