<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    // Nama tabel jika tidak menggunakan konvensi default 'users'
    protected $table = 'users';

    // Kolom yang dapat diisi secara mass assignment
    protected $fillable = [
        'name',
        'username',
        'email',
        'password',
        'role',
        'profile',
    ];

    // Kolom yang disembunyikan saat serialisasi
    protected $hidden = [
        'password',
        'remember_token',
    ];

    // Cast atribut ke tipe data tertentu
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    // Jika menggunakan kolom timestamps (created_at, updated_at), ini sudah default true.
    public $timestamps = true;

    public function pelanggan()
    {
        return $this->hasOne(Pelanggan::class);
    }
}
