<?php
require 'vendor/autoload.php';
$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== CHECKING DATABASE DATA ===\n";

// Check Sales data
$salesCount = App\Models\Sales::count();
echo "Sales count: " . $salesCount . "\n";

if ($salesCount > 0) {
    echo "Sales data:\n";
    $sales = App\Models\Sales::select('id', 'nama')->get();
    foreach ($sales as $sale) {
        echo "  ID: {$sale->id}, Nama: {$sale->nama}\n";
    }
} else {
    echo "No sales data found!\n";
}

// Check Products data
$productsCount = App\Models\Product::count();
echo "\nProducts count: " . $productsCount . "\n";

if ($productsCount > 0) {
    echo "Recent products:\n";
    $products = App\Models\Product::latest()->take(5)->get();
    foreach ($products as $product) {
        echo "  ID: {$product->id}, Nama: {$product->nama_produk}, Sales ID: {$product->id_sales}\n";
    }
}

echo "\n=== END CHECK ===\n";
