<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('cicilan_histories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('pelacakan_id');
            $table->unsignedBigInteger('pelanggan_id');
            $table->integer('jumlah_cicilan');
            $table->enum('metode_pembayaran', ['transfer', 'tunai']);
            $table->string('bukti')->nullable();
            $table->timestamps();

            $table->foreign('pelacakan_id')->references('id')->on('pelacakans')->onDelete('cascade');
            $table->foreign('pelanggan_id')->references('id')->on('pelanggans')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('cicilan_histories');
    }
};
