<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Ubah enum role, tambahkan 'Owner'
        Schema::table('users', function (Blueprint $table) {
            $table->enum('role', ['Admin', 'Karyawan', 'Kurir', 'Customer', 'Owner'])->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Kembalikan enum role ke semula
        Schema::table('users', function (Blueprint $table) {
            $table->enum('role', ['Admin', 'Karyawan', 'Kurir', 'Customer'])->change();
        });
    }
};
