<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('inventories', function (Blueprint $table) {
            $table->unsignedBigInteger('id_pelacakan')->nullable()->after('id_karyawan');
            $table->foreign('id_pelacakan')->references('id')->on('pelacakans')->onDelete('set null');
        });

        Schema::table('pelacakans', function (Blueprint $table) {
            $table->dropForeign(['id_inventory']);
            $table->dropColumn('id_inventory');
        });
    }

    public function down()
    {
        Schema::table('inventories', function (Blueprint $table) {
            $table->dropForeign(['id_pelacakan']);
            $table->dropColumn('id_pelacakan');
        });

        Schema::table('pelacakans', function (Blueprint $table) {
            $table->unsignedBigInteger('id_inventory')->nullable()->after('id_customer');
            $table->foreign('id_inventory')->references('id')->on('inventories')->onDelete('set null');
        });
    }
};
