<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('klasifikasi', function (Blueprint $table) {
            // Tambahkan field baru setelah 'type'
            $table->string('subject')->after('type');
            $table->string('var')->after('subject');
            $table->string('turvar')->after('var');
            $table->string('jenis_tangguh')->after('turvar'); // (keatas, kebawah)
            $table->double('batas_bawah')->after('jenis_tangguh');
            $table->double('batas_atas')->after('batas_bawah');
            $table->double('batas_atas1')->after('batas_atas');
            $table->double('batas_atas2')->after('batas_atas1');
            $table->double('batas_atas3')->after('batas_atas2');
            $table->double('batas_atas4')->after('batas_atas3');
            $table->double('batas_atas5')->after('batas_atas4');

            // Hapus field 'from' dan 'to'
            $table->dropColumn(['from', 'to']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('klasifikasi', function (Blueprint $table) {
            // Kembalikan field yang dihapus
            $table->double('from')->after('kode');
            $table->double('to')->after('from');

            // Hapus field yang ditambahkan
            $table->dropColumn([
                'subject',
                'var',
                'turvar',
                'jenis_tangguh',
                'batas_bawah',
                'batas_atas',
                'batas_atas1',
                'batas_atas2',
                'batas_atas3',
                'batas_atas4',
                'batas_atas5',
            ]);
        });
    }
};