<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('klasifikasi', function (Blueprint $table) {
            // Ubah field string agar nullable
            $table->string('gatra')->nullable()->change();
            $table->string('type')->nullable()->change();
            $table->string('subject')->nullable()->change();
            $table->string('var')->nullable()->change();
            $table->string('turvar')->nullable()->change();
            $table->string('jenis_tangguh')->nullable()->change();
            $table->string('title')->nullable()->change();
            $table->string('api')->nullable()->change();
            $table->string('kode')->nullable()->change();
            
            // Ubah field double dengan default 0.0
            $table->double('batas_bawah')->default(0.0)->change();
            $table->double('batas_atas')->default(0.0)->change();
            $table->double('batas_atas1')->default(0.0)->change();
            $table->double('batas_atas2')->default(0.0)->change();
            $table->double('batas_atas3')->default(0.0)->change();
            $table->double('batas_atas4')->default(0.0)->change();
            $table->double('batas_atas5')->default(0.0)->change();
            
            // Ubah field integer dengan default 0
            $table->integer('indeks')->default(0)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('klasifikasi', function (Blueprint $table) {
            // Kembalikan ke NOT NULL tanpa default
            $table->string('gatra')->nullable(false)->change();
            $table->string('type')->nullable(false)->change();
            $table->string('subject')->nullable(false)->change();
            $table->string('var')->nullable(false)->change();
            $table->string('turvar')->nullable(false)->change();
            $table->string('jenis_tangguh')->nullable(false)->change();
            $table->string('title')->nullable(false)->change();
            $table->string('api')->nullable(false)->change();
            $table->string('kode')->nullable(false)->change();
            
            // Kembalikan double tanpa default
            $table->double('batas_bawah')->change();
            $table->double('batas_atas')->change();
            $table->double('batas_atas1')->change();
            $table->double('batas_atas2')->change();
            $table->double('batas_atas3')->change();
            $table->double('batas_atas4')->change();
            $table->double('batas_atas5')->change();
            
            // Kembalikan integer tanpa default
            $table->integer('indeks')->change();
        });
    }
};