<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('klasifikasi', function (Blueprint $table) {
            $table->integer('tahun_id')->default(0)->after('turvar');
            $table->string('tahun')->nullable()->after('tahun_id');
            $table->integer('turtahun_id')->default(0)->after('tahun');
            $table->string('turtahun')->nullable()->after('turtahun_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('klasifikasi', function (Blueprint $table) {
            $table->dropColumn(['tahun_id', 'tahun', 'turtahun_id', 'turtahun']);
        });
    }
};
