<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('provinsi', function (Blueprint $table) {
            $table->id();
            $table->string('kode', 2)->unique();
            $table->string('nama', 100);
            $table->timestamps();
        });

        // Insert initial data
        DB::table('provinsi')->insert([
            ['id' => 1, 'kode' => '11', 'nama' => 'ACEH', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 2, 'kode' => '12', 'nama' => 'SUMATERA UTARA', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 3, 'kode' => '13', 'nama' => 'SUMATERA BARAT', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 4, 'kode' => '14', 'nama' => 'RIAU', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 5, 'kode' => '15', 'nama' => 'JAMBI', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 6, 'kode' => '16', 'nama' => 'SUMATERA SELATAN', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 7, 'kode' => '17', 'nama' => 'BENGKULU', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 8, 'kode' => '18', 'nama' => 'LAMPUNG', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 9, 'kode' => '19', 'nama' => 'KEPULAUAN BANGKA BELITUNG', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 10, 'kode' => '21', 'nama' => 'KEPULAUAN RIAU', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 11, 'kode' => '31', 'nama' => 'DKI JAKARTA', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 12, 'kode' => '32', 'nama' => 'JAWA BARAT', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 13, 'kode' => '33', 'nama' => 'JAWA TENGAH', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 14, 'kode' => '34', 'nama' => 'DI YOGYAKARTA', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 15, 'kode' => '35', 'nama' => 'JAWA TIMUR', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 16, 'kode' => '36', 'nama' => 'BANTEN', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 17, 'kode' => '51', 'nama' => 'BALI', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 18, 'kode' => '52', 'nama' => 'NUSA TENGGARA BARAT', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 19, 'kode' => '53', 'nama' => 'NUSA TENGGARA TIMUR', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 20, 'kode' => '61', 'nama' => 'KALIMANTAN BARAT', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 21, 'kode' => '62', 'nama' => 'KALIMANTAN TENGAH', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 22, 'kode' => '63', 'nama' => 'KALIMANTAN SELATAN', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 23, 'kode' => '64', 'nama' => 'KALIMANTAN TIMUR', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 24, 'kode' => '65', 'nama' => 'KALIMANTAN UTARA', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 25, 'kode' => '71', 'nama' => 'SULAWESI UTARA', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 26, 'kode' => '72', 'nama' => 'SULAWESI TENGAH', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 27, 'kode' => '73', 'nama' => 'SULAWESI SELATAN', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 28, 'kode' => '74', 'nama' => 'SULAWESI TENGGARA', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 29, 'kode' => '75', 'nama' => 'GORONTALO', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 30, 'kode' => '76', 'nama' => 'SULAWESI BARAT', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 31, 'kode' => '81', 'nama' => 'MALUKU', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 32, 'kode' => '82', 'nama' => 'MALUKU UTARA', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 33, 'kode' => '91', 'nama' => 'PAPUA BARAT', 'created_at' => now(), 'updated_at' => now()],
            ['id' => 34, 'kode' => '94', 'nama' => 'PAPUA', 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('provinsi');
    }
};
