<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Gatra;

class GatraSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $gatraData = [
            [
                'gatra' => 'Geografi',
                'bobot' => 8,
                'skor' => 2.82,
                'bobot_x_skor' => 22.56,
            ],
            [
                'gatra' => 'Demografi',
                'bobot' => 12,
                'skor' => 3.16,
                'bobot_x_skor' => 37.92,
            ],
            [
                'gatra' => 'Sumber Kekayaan Alam',
                'bobot' => 10,
                'skor' => 1.85,
                'bobot_x_skor' => 18.50,
            ],
            [
                'gatra' => 'Ideologi',
                'bobot' => 10,
                'skor' => 1.93,
                'bobot_x_skor' => 19.30,
            ],
            [
                'gatra' => 'Politik',
                'bobot' => 11,
                'skor' => 2.89,
                'bobot_x_skor' => 31.79,
            ],
            [
                'gatra' => 'Ekonomi',
                'bobot' => 17,
                'skor' => 2.80,
                'bobot_x_skor' => 47.60,
            ],
            [
                'gatra' => 'Sosial Budaya',
                'bobot' => 16,
                'skor' => 2.61,
                'bobot_x_skor' => 41.76,
            ],
            [
                'gatra' => 'Pertahanan & Keamanan',
                'bobot' => 16,
                'skor' => 2.58,
                'bobot_x_skor' => 41.28,
            ],
        ];

        foreach ($gatraData as $data) {
            Gatra::create($data);
        }
    }
}
