<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Pelanggan;
use Illuminate\Support\Facades\Hash;

class TestUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Test Admin User
        $admin = User::updateOrCreate(
            ['email' => 'admin@test.com'],
            [
                'name' => 'Admin Test',
                'username' => 'admintest',
                'password' => Hash::make('password123'),
                'role' => 'Admin',
            ]
        );

        // Test Customer User
        $customer = User::updateOrCreate(
            ['email' => 'customer@test.com'],
            [
                'name' => 'Customer Test',
                'username' => 'customertest',
                'password' => Hash::make('password123'),
                'role' => 'Customer',
            ]
        );

        // Buat data pelanggan untuk customer jika belum ada
        Pelanggan::updateOrCreate(
            ['user_id' => $customer->id],
            ['nama_pelanggan' => $customer->name]
        );

        // Test Owner User
        $owner = User::updateOrCreate(
            ['email' => 'owner@test.com'],
            [
                'name' => 'Owner Test',
                'username' => 'ownertest',
                'password' => Hash::make('password123'),
                'role' => 'Owner',
            ]
        );

        echo "Test users created/updated successfully!\n";
        echo "Admin: admin@test.com / password123 (username: admintest)\n";
        echo "Customer: customer@test.com / password123 (username: customertest)\n";
        echo "Owner: owner@test.com / password123 (username: ownertest)\n";
    }
}
