<?php
require 'vendor/autoload.php';
$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== DEBUGGING SUMMARY ===\n";

echo "1. Sales data available: " . App\Models\Sales::count() . " items\n";
foreach (App\Models\Sales::all() as $sales) {
    echo "   - ID: {$sales->id}, Name: {$sales->nama}\n";
}

echo "\n2. Products data available: " . App\Models\Product::count() . " items\n";
foreach (App\Models\Product::all() as $product) {
    echo "   - ID: {$product->id}, Name: {$product->nama_produk}, Sales ID: {$product->id_sales}\n";
}

echo "\n3. Model validation test:\n";
try {
    $testProduct = new App\Models\Product([
        'nama_produk' => 'Test',
        'foto_produk' => 'default-product.svg',
        'harga_produk' => 10000,
        'stok_produk' => 5,
        'best_seller' => 0,
        'id_sales' => 1,
    ]);
    echo "   ✓ Model can be instantiated\n";
    
    $testProduct->save();
    echo "   ✓ Model can be saved (ID: {$testProduct->id})\n";
    
} catch (Exception $e) {
    echo "   ✗ Model error: " . $e->getMessage() . "\n";
}

echo "\n4. Storage directory check:\n";
$storageDir = storage_path('app/public/foto_produk');
echo "   Storage path: {$storageDir}\n";
echo "   Directory exists: " . (is_dir($storageDir) ? 'YES' : 'NO') . "\n";

$publicStorageDir = public_path('storage/foto_produk');
echo "   Public storage path: {$publicStorageDir}\n";
echo "   Public directory exists: " . (is_dir($publicStorageDir) ? 'YES' : 'NO') . "\n";
echo "   Default image exists: " . (file_exists($publicStorageDir . '/default-product.svg') ? 'YES' : 'NO') . "\n";

echo "\n=== ISSUE ANALYSIS ===\n";
echo "Database works: ✓\n";
echo "Model works: ✓\n";
echo "Validation works: ✓\n";
echo "Manual creation works: ✓\n";
echo "\nConclusion: Issue is likely in the web form submission process.\n";
echo "Possible causes:\n";
echo "1. CSRF token mismatch\n";
echo "2. Form not submitting properly\n";
echo "3. JavaScript interference\n";
echo "4. Middleware blocking request\n";
echo "5. Session issues\n";

echo "\n=== RECOMMENDATIONS ===\n";
echo "1. Check browser console for JavaScript errors\n";
echo "2. Check network tab to see if form is actually submitting\n";
echo "3. Temporarily disable any JavaScript on the form\n";
echo "4. Check Laravel logs during form submission\n";
echo "5. Try submitting with different browsers\n";

echo "\n=== END DEBUGGING ===\n";
