<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

use App\Models\Klasifikasi;
use App\Models\DetailKlasifikasi;

echo "=== Debug Klasifikasi JSON Data ===\n\n";

try {
    // Get the latest klasifikasi
    $klasifikasi = Klasifikasi::latest()->first();
    
    if (!$klasifikasi) {
        echo "No klasifikasi found!\n";
        exit;
    }
    
    echo "Klasifikasi found: {$klasifikasi->gatra}\n";
    echo "Selected turvar_id: {$klasifikasi->turvar_id}\n";
    echo "Selected tahun_id: {$klasifikasi->tahun_id}\n";
    echo "Selected turtahun_id: {$klasifikasi->turtahun_id}\n\n";
    
    // Try to fetch and parse JSON data from API
    $apiUrl = $klasifikasi->api;
    echo "API URL: {$apiUrl}\n\n";
    
    // Get JSON data from API
    $jsonResponse = file_get_contents($apiUrl);
    
    if (!$jsonResponse) {
        echo "Failed to fetch JSON data from API\n";
        exit;
    }
    
    $jsonData = json_decode($jsonResponse, true);
    
    if (!$jsonData) {
        echo "Failed to parse JSON data\n";
        exit;
    }
    
    echo "JSON data successfully fetched and parsed.\n\n";
    
    // Check datacontent
    $datacontent = $jsonData['datacontent'] ?? [];
    echo "Datacontent entries: " . count($datacontent) . "\n";
    
    // Show first few datacontent entries
    $count = 0;
    foreach ($datacontent as $datacontentId => $datacontentVal) {
        if ($count >= 5) break;
        echo "  - $datacontentId => $datacontentVal\n";
        
        // Parse this datacontent_id
        $length = strlen($datacontentId);
        if ($length >= 15) {
            $vervar_id = (int)substr($datacontentId, 0, 4);
            $var_id = (int)substr($datacontentId, 4, 3);
            $turvar_id = (int)substr($datacontentId, 7, 3);
            $tahun_id = (int)substr($datacontentId, 10, 3);
            $turtahun_id = (int)substr($datacontentId, 13, 2);
            
            echo "    Parsed: vervar=$vervar_id, var=$var_id, turvar=$turvar_id, tahun=$tahun_id, turtahun=$turtahun_id\n";
            echo "    Match turvar? " . ($turvar_id == $klasifikasi->turvar_id ? 'YES' : 'NO') . "\n";
            echo "    Match tahun? " . ($tahun_id == $klasifikasi->tahun_id ? 'YES' : 'NO') . "\n";
            echo "    Match turtahun? " . ($turtahun_id == $klasifikasi->turtahun_id ? 'YES' : 'NO') . "\n";
        }
        echo "\n";
        $count++;
    }
    
    // Check vervar data
    $vervarList = $jsonData['vervar'] ?? [];
    echo "Vervar entries: " . count($vervarList) . "\n";
    
    // Show first few vervar entries
    foreach (array_slice($vervarList, 0, 5) as $vervar) {
        echo "  - {$vervar['val']} => {$vervar['label']}\n";
    }
    
    echo "\n=== Debug Completed ===\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
