<?php

// Test parsing logic
$vervarList = [
    ['val' => 1, 'label' => 'ACEH'],
    ['val' => 2, 'label' => 'SUMATERA UTARA'],
    ['val' => 3, 'label' => 'SUMATERA BARAT'],
    ['val' => 32, 'label' => 'MALUKU UTARA'],
];

$datacontent = [
    "329701230" => 69.34,   // Should be SUMATERA BARAT (vervar: 3)
    "3229701230" => 45.07,  // Should be MALUKU UTARA (vervar: 32)
];

function parseDatacontentId($datacontentId, $vervarList = []) {
    $length = strlen($datacontentId);
    
    // Get all possible vervar values for matching
    $vervarValues = array_column($vervarList, 'val');
    rsort($vervarValues); // Sort descending to try longer matches first
    
    echo "Parsing: $datacontentId (length: $length)\n";
    
    // Try to find the correct vervar_id by matching against known values
    foreach ($vervarValues as $vervarVal) {
        $vervarStr = (string)$vervarVal;
        $vervarLength = strlen($vervarStr);
        
        echo "  Trying vervar: $vervarVal (length: $vervarLength)\n";
        
        // Check if datacontent_id starts with this vervar value
        if (substr($datacontentId, 0, $vervarLength) == $vervarStr) {
            $remainingId = substr($datacontentId, $vervarLength);
            $remainingLength = strlen($remainingId);
            
            echo "    Match! Remaining: $remainingId (length: $remainingLength)\n";
            
            // For the pattern: var(3) + turvar(1) + tahun(3) + turtahun(1) = 8 chars remaining
            if ($remainingLength >= 8) {
                $result = [
                    'vervar_id' => (int)$vervarVal,
                    'var_id' => (int)substr($remainingId, 0, 3),      // Next 3 digits
                    'turvar_id' => (int)substr($remainingId, 3, 1),   // Next 1 digit
                    'tahun_id' => (int)substr($remainingId, 4, 3),    // Next 3 digits
                    'turtahun_id' => (int)substr($remainingId, 7, 1), // Last 1 digit
                ];
                
                echo "    Result: " . json_encode($result) . "\n";
                return $result;
            }
        }
    }
    
    echo "  No match found, using fallback\n";
    return ['vervar_id' => 0, 'var_id' => 0, 'turvar_id' => 0, 'tahun_id' => 0, 'turtahun_id' => 0];
}

// Test the examples
foreach ($datacontent as $id => $val) {
    echo "Testing: $id = $val\n";
    $parsed = parseDatacontentId($id, $vervarList);
    
    // Find vervar label
    $vervarData = null;
    foreach ($vervarList as $item) {
        if ($item['val'] == $parsed['vervar_id']) {
            $vervarData = $item;
            break;
        }
    }
    
    echo "Result: " . ($vervarData ? $vervarData['label'] : 'NOT FOUND') . "\n";
    echo "Parsed: " . json_encode($parsed) . "\n\n";
}
