<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

use App\Models\Klasifikasi;
use App\Models\DetailKlasifikasi;
use App\Http\Controllers\KlasifikasiController;

echo "=== Reprocess Klasifikasi Data ===\n\n";

try {
    // Get the latest klasifikasi
    $klasifikasi = Klasifikasi::latest()->first();
    
    if (!$klasifikasi) {
        echo "No klasifikasi found!\n";
        exit;
    }
    
    echo "Processing klasifikasi: {$klasifikasi->gatra} (ID: {$klasifikasi->id})\n\n";
    
    // Delete existing detail klasifikasi
    $deletedCount = DetailKlasifikasi::where('klasifikasi_id', $klasifikasi->id)->delete();
    echo "Deleted $deletedCount existing detail records\n\n";
    
    // Get JSON data from API
    $apiUrl = $klasifikasi->api;
    echo "Fetching data from: {$apiUrl}\n";
    
    $jsonResponse = file_get_contents($apiUrl);
    
    if (!$jsonResponse) {
        echo "Failed to fetch JSON data from API\n";
        exit;
    }
    
    $jsonData = json_decode($jsonResponse, true);
    
    if (!$jsonData) {
        echo "Failed to parse JSON data\n";
        exit;
    }
    
    echo "JSON data fetched successfully\n\n";
    
    // Prepare parent data
    $parentData = [
        'gatra' => $klasifikasi->gatra,
        'subject_id' => $klasifikasi->subject_id,
        'subject' => $klasifikasi->subject,
        'var_id' => $klasifikasi->var_id,
        'var' => $klasifikasi->var,
        'turvar_id' => $klasifikasi->turvar_id,
        'turvar' => $klasifikasi->turvar,
        'tahun_id' => $klasifikasi->tahun_id,
        'tahun' => $klasifikasi->tahun,
        'turtahun_id' => $klasifikasi->turtahun_id,
        'turtahun' => $klasifikasi->turtahun,
        'jenis_tangguh' => $klasifikasi->jenis_tangguh,
        'batas_bawah' => $klasifikasi->batas_bawah,
        'batas_atas1' => $klasifikasi->batas_atas1,
        'batas_atas2' => $klasifikasi->batas_atas2,
        'batas_atas3' => $klasifikasi->batas_atas3,
        'batas_atas4' => $klasifikasi->batas_atas4,
        'batas_atas5' => $klasifikasi->batas_atas5,
    ];
    
    // Process data manually
    $datacontent = $jsonData['datacontent'] ?? [];
    $vervarList = $jsonData['vervar'] ?? [];
    $labelvervar = $jsonData['labelvervar'] ?? '';
    
    echo "Processing " . count($datacontent) . " datacontent entries...\n";
    echo "Available " . count($vervarList) . " vervar entries...\n\n";
    
    $insertedCount = 0;
    
    foreach ($datacontent as $datacontentId => $datacontentVal) {
        // Parse datacontent_id to get components
        $length = strlen($datacontentId);
        if ($length >= 15) {
            $vervar_id = (int)substr($datacontentId, 0, 4);
            
            // Find vervar data
            $vervarData = collect($vervarList)->firstWhere('val', $vervar_id);
            
            if ($vervarData && $datacontentVal > 0) {
                // Calculate nilai_indeks
                $datacontentVal = (float)$datacontentVal;
                $jenisTangguh = $parentData['jenis_tangguh'];
                
                // Define boundaries
                $boundaries = [
                    ['min' => $parentData['batas_bawah'], 'max' => $parentData['batas_atas1']],
                    ['min' => $parentData['batas_atas1'], 'max' => $parentData['batas_atas2']],
                    ['min' => $parentData['batas_atas2'], 'max' => $parentData['batas_atas3']],
                    ['min' => $parentData['batas_atas3'], 'max' => $parentData['batas_atas4']],
                    ['min' => $parentData['batas_atas4'], 'max' => $parentData['batas_atas5']],
                ];

                // Determine which boundary the value falls into
                $indeks = 5; // default to highest category
                for ($i = 0; $i < count($boundaries); $i++) {
                    if ($datacontentVal >= $boundaries[$i]['min'] && $datacontentVal < $boundaries[$i]['max']) {
                        $indeks = $i + 1;
                        break;
                    }
                    // Special case for the last boundary (includes upper limit)
                    if ($i == count($boundaries) - 1 && $datacontentVal <= $boundaries[$i]['max']) {
                        $indeks = $i + 1;
                        break;
                    }
                }

                // If jenis_tangguh is 'kebawah', invert the index
                if ($jenisTangguh === 'kebawah') {
                    $indeks = 6 - $indeks; // Convert 1->5, 2->4, 3->3, 4->2, 5->1
                }

                DetailKlasifikasi::create([
                    'klasifikasi_id' => $klasifikasi->id,
                    'gatra' => $parentData['gatra'],
                    'subject_id' => $parentData['subject_id'],
                    'subject' => $parentData['subject'],
                    'turvar_id' => $parentData['turvar_id'],
                    'turvar' => $parentData['turvar'],
                    'var_id' => $parentData['var_id'],
                    'var' => $parentData['var'],
                    'vervar_id' => $vervarData['val'],
                    'labelvervar' => $labelvervar,
                    'vervar' => $vervarData['label'],
                    'prov_id' => $vervarData['val'],
                    'prov' => $vervarData['label'],
                    'tahun_id' => $parentData['tahun_id'],
                    'tahun' => $parentData['tahun'],
                    'turtahun_id' => $parentData['turtahun_id'],
                    'turtahun' => $parentData['turtahun'],
                    'datacontent_id' => $datacontentId,
                    'datacontent_val' => $datacontentVal,
                    'nilai_indeks' => $indeks,
                ]);
                
                $insertedCount++;
                
                if ($insertedCount <= 5) {
                    echo "Inserted: {$vervarData['label']} - Val: $datacontentVal - Indeks: $indeks\n";
                }
            }
        }
    }
    
    echo "\nTotal inserted: $insertedCount detail records\n";
    echo "\n=== Processing Completed ===\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
