<header>
  <!-- Header Middle Start Here -->
  <div class="header-middle ptb-15">
    <div class="container">
      <div class="row align-items-center no-gutters">
        <div class="col-lg-3 col-md-12">
          <div class="logo mb-all-30">
            <a href="{{ route('homepage') }}"><img src="{{ asset('assets/homepage/img/logo/logo.png') }}" width="214" height="58"
                alt="logo-image"></a>
          </div>
        </div>
        <!-- Categorie Search Box Start Here -->
        <div class="col-lg-5 col-md-8 ml-auto mr-auto col-10">
          <div class="categorie-search-box">
            <form action="{{ route('product.search') }}" method="get">
              <input type="text" name="search" value="{{ request('search') }}" placeholder="I’m shopping for...">
              <button type="submit"><i class="lnr lnr-magnifier"></i></button>
            </form>
          </div>
        </div>
        <!-- Categorie Search Box End Here -->
        <!-- Cart Box Start Here -->
        <div class="col-lg-4 col-md-12">
          <div class="cart-box mt-all-30">
            <ul class="d-flex justify-content-lg-end justify-content-center align-items-center">
              <li><a href="{{ route('product.cart') }}"><i class="lnr lnr-cart"></i><span class="my-cart"><span class="total-pro"
                      id="cart-count">{{ $cartCount ?? '0' }}</span><span>cart</span></span></a>
                <ul class="ht-dropdown cart-box-width">
                  <li>
                    <div class="cart-items-wrapper">
                      @foreach ($cartItems ?? [] as $ci)
                        <!-- Cart Box Start -->
                        <div class="single-cart-box" id="cart-item-{{ $ci->produk->id }}">
                          <div class="cart-img">
                            <a href="{{ route('product.detail', $ci->produk->id) }}"><img
                                src="{{ asset('storage/foto_produk/' . $ci->produk->foto_produk) }}" alt="cart-image"></a>
                            <span class="pro-quantity">{{ $ci->quantity }}</span>
                          </div>
                          <div class="cart-content">
                            <h6><a href="{{ route('product.detail', $ci->produk->id) }}">{{ $ci->produk->nama_produk }}</a></h6>
                            <span class="cart-price">Rp{{ number_format($ci->produk->harga_produk, 0, ',', '.') }}</span>
                          </div>
                          <a href="javascript:void(0)" class="del-icone remove-item" data-id="{{ $ci->produk->id }}"
                            data-urlcart="{{ route('product.remove.cart', $ci->produk->id) }}">
                            <i class="ion-close"></i>
                          </a>
                        </div>
                        <!-- Cart Box End -->
                      @endforeach
                    </div> <!-- END .cart-items-wrapper -->
                    @if (isset($cartItems) && $cartItems->count())
                      <!-- Cart Footer Inner Start -->
                      <div class="cart-footer">
                        <ul class="price-content">
                          <li>Total <span id="cart-total-price">Rp{{ number_format($totalPrice, 0, ',', '.') }}</span></li>
                        </ul>
                        <div class="cart-actions text-center">
                          <a class="cart-checkout" href="{{ route('product.checkout') }}">Checkout</a>
                        </div>
                      </div>
                      <!-- Cart Footer Inner End -->
                    @else
                      <p class="text-center keranjang-kosong">Keranjang kosong...</p>
                    @endif
                  </li>
                </ul>
              </li>
              @if (Auth::check())
                <li>
                  <a href="javascript:void(0)"><i class="lnr lnr-user"></i>
                    <span class="my-cart">
                      <span><strong>{{ Auth::user()->name }}</strong></span>
                      <span>{{ Auth::user()->role }}</span>
                    </span>
                  </a>
                  <ul class="ht-dropdown profile-dropdown">
                    <li><a href="javascript:void(0)" data-toggle="modal" data-target="#editProfileModal">Profile</a></li>
                    @if (Auth::user()->role !== 'Customer')
                      <li><a href="/admin/dashboard">Dashboard</a></li>
                    @endif
                    <li><a href="{{ route('product.order') }}">Pesanan</a></li>
                    <li><a href="/logout">Logout</a></li>
                  </ul>
                </li>
              @else
                <li>
                  <a href="/login"><i class="lnr lnr-user"></i>
                    <span class="my-cart">
                      <span><strong>Sign in</strong> Or</span>
                      <span>Join My Site</span>
                    </span>
                  </a>
                </li>
              @endif
            </ul>
          </div>
        </div>
        <!-- Cart Box End Here -->
      </div>
      <!-- Row End -->
    </div>
    <!-- Container End -->
  </div>
  <!-- Header Middle End Here -->
  <!-- Modal Edit Profil -->
  <div class="modal fade" id="editProfileModal" tabindex="-1" role="dialog" aria-labelledby="editProfileModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <form method="POST" action="{{ route('profile.update') }}">
        @csrf
        @method('PUT')
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="editProfileModalLabel">Edit Profil</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>

          <div class="modal-body">
            <!-- Nama -->
            <div class="form-group">
              <label for="name">Nama Lengkap</label>
              <input type="text" name="name" class="form-control" id="name" value="{{ Auth::user()->name ?? '' }}" required>
            </div>

            <!-- Email -->
            <div class="form-group">
              <label for="email">Email</label>
              <input type="email" name="email" class="form-control" id="email" value="{{ Auth::user()->email ?? '' }}" required>
            </div>

            <!-- No HP (jika ada di DB) -->
            <div class="form-group">
              <label for="phone">Nomor HP</label>
              <input type="text" name="phone" class="form-control" id="phone" value="{{ Auth::user()->pelanggan->phone ?? '' }}">
            </div>

            <!-- Alamat -->
            <div class="form-group">
              <label for="alamat_pelanggan">Alamat</label>
              <textarea name="alamat_pelanggan" class="form-control" id="alamat_pelanggan"
                placeholder="Contoh: Jl. Merdeka No. 45, RT 03 RW 07, Kelurahan Sukamaju, Kecamatan Kebon Jeruk, Kota Jakarta Barat" required>{{ Auth::user()->pelanggan->alamat_pelanggan ?? '' }}</textarea>
            </div>

            <!-- Password opsional -->
            <div class="form-group">
              <label for="password">Password Baru <small>(kosongkan jika tidak diganti)</small></label>
              <input type="password" name="password" class="form-control" id="password">
            </div>

            <div class="form-group">
              <label for="password_confirmation">Konfirmasi Password Baru</label>
              <input type="password" name="password_confirmation" class="form-control" id="password_confirmation">
            </div>
          </div>

          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
            <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
          </div>
        </div>
      </form>
    </div>
  </div>

  @section('script-header')
    @if (session('success'))
      <script>
        Swal.fire({
          icon: 'success',
          title: 'Berhasil',
          text: '{{ session('success') }}',
          timer: 3000
        });
      </script>
    @endif

    @if ($errors->any())
      <script>
        Swal.fire({
          icon: 'error',
          title: 'Gagal',
          html: `{!! implode('<br>', $errors->all()) !!}`,
          timer: 5000
        });
      </script>
    @endif

    <script>
      $(document).ready(function() {
        $(document).on('click', '.remove-item', function(e) {
          e.preventDefault();

          const $this = $(this);
          const itemId = $this.data('id');
          const url = $(this).data('urlcart');

          $.ajax({
            url: url,
            method: 'DELETE',
            data: {
              _token: '{{ csrf_token() }}',
            },
            success: function(response) {
              // Animasikan penghapusan
              $('#cart-item-' + itemId).slideUp(300, function() {
                $(this).remove();

                // Kalau tidak ada item tersisa, bisa tampilkan pesan
                if ($('.single-cart-box').length === 0) {
                  $('.cart-footer').remove(); // hapus footer
                  $('.cart-items-wrapper').html('<p class="text-center keranjang-kosong">Keranjang kosong...</p>');
                }
              });

              // Update jumlah barang
              if (response.cartCount !== undefined) {
                $('#cart-count').text(response.cartCount);
              }
              // Update total harga
              if (response.totalPrice !== undefined) {
                $('#cart-total-price').text('Rp' + formatRupiah(response.totalPrice));
              }
            },
            error: function(xhr) {
              Swal.fire({
                icon: "error",
                title: "Error",
                text: xhr.responseJSON?.message || 'Terjadi kesalahan saat menghapus item',
                timer: 4000,
              });
            }
          });
        });

        // Fungsi format Rupiah
        function formatRupiah(angka) {
          return angka.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
        }
      });
    </script>
  @endsection
</header>
