<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Index Dar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #1a1a1a 0%, #2d1b1b 50%, #3d0a0a 100%);
            min-height: 100vh;
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .login-container {
            background: linear-gradient(145deg, #ffffff 0%, #f8f8f8 100%);
            border-radius: 20px;
            box-shadow: 0 25px 50px rgba(0,0,0,0.3), 0 0 0 1px rgba(212, 175, 55, 0.1);
            overflow: hidden;
            max-width: 900px;
            width: 100%;
            min-height: 500px;
            border: 2px solid rgba(212, 175, 55, 0.2);
        }
        
        .login-image {
            background: linear-gradient(45deg, rgba(26, 26, 26, 0.8) 0%, rgba(139, 0, 0, 0.8) 50%, rgba(26, 26, 26, 0.8) 100%),
                        url('{{ asset("assets/images/logo.png") }}') center/cover no-repeat;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }
        
        .login-image::before {
            content: '';
            position: absolute;
            width: 200%;
            height: 200%;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="50" cy="50" r="1" fill="gold" opacity="0.05"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            animation: float 20s ease-in-out infinite;
        }
        
        .login-image::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, transparent 30%, rgba(212, 175, 55, 0.1) 50%, transparent 70%);
            z-index: 1;
        }
        
        .image-overlay {
            position: relative;
            z-index: 3;
            background: rgba(0, 0, 0, 0.4);
            padding: 2rem;
            border-radius: 15px;
            backdrop-filter: blur(5px);
            border: 1px solid rgba(212, 175, 55, 0.3);
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-10px) rotate(180deg); }
        }
        
        .login-icon {
            font-size: 4rem;
            color: #D4AF37;
            z-index: 2;
            position: relative;
            text-shadow: 0 4px 8px rgba(0,0,0,0.5);
            filter: drop-shadow(0 0 10px rgba(212, 175, 55, 0.3));
        }
        
        .login-form {
            padding: 3rem;
            display: flex;
            flex-direction: column;
            justify-content: center;
            background: linear-gradient(135deg, #ffffff 0%, #f9f9f9 100%);
        }
        
        .login-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #1a1a1a;
            margin-bottom: 0.5rem;
            text-align: center;
            text-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .login-subtitle {
            color: #666;
            text-align: center;
            margin-bottom: 2rem;
            font-size: 1rem;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
            position: relative;
        }
        
        .form-label {
            font-weight: 600;
            color: #1a1a1a;
            margin-bottom: 0.5rem;
            display: block;
        }
        
        .form-control {
            border: 2px solid #e1e5e9;
            border-radius: 12px;
            padding: 1rem 1rem 1rem 3rem;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: #ffffff;
        }
        
        .form-control:focus {
            border-color: #D4AF37;
            box-shadow: 0 0 0 0.2rem rgba(212, 175, 55, 0.25);
            background: white;
            outline: none;
        }
        
        .input-icon {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: #8B0000;
            z-index: 2;
        }
        
        .btn-login {
            background: linear-gradient(135deg, #1a1a1a 0%, #8B0000 50%, #1a1a1a 100%);
            border: 2px solid #D4AF37;
            border-radius: 12px;
            padding: 1rem 2rem;
            color: white;
            font-weight: 600;
            font-size: 1.1rem;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(139, 0, 0, 0.4);
            position: relative;
            overflow: hidden;
        }
        
        .btn-login::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            background: linear-gradient(45deg, #D4AF37, #FFD700);
            transition: all 0.3s ease;
            transform: translate(-50%, -50%);
            z-index: 0;
        }
        
        .btn-login:hover::before {
            width: 100%;
            height: 100%;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(212, 175, 55, 0.6);
            color: #1a1a1a;
            border-color: #FFD700;
        }
        
        .btn-login i,
        .btn-login span {
            position: relative;
            z-index: 1;
        }
        
        .alert {
            border-radius: 12px;
            border: none;
            padding: 1rem;
            margin-bottom: 1.5rem;
        }
        
        .alert-danger {
            background: linear-gradient(135deg, #8B0000, #DC143C);
            color: white;
            border: 1px solid #D4AF37;
        }
        
        .invalid-feedback {
            color: #8B0000;
            font-size: 0.875rem;
            margin-top: 0.25rem;
            font-weight: 500;
        }
        
        .is-invalid {
            border-color: #8B0000;
            box-shadow: 0 0 0 0.2rem rgba(139, 0, 0, 0.25);
        }
        
        @media (max-width: 768px) {
            .login-container {
                margin: 1rem;
                border-radius: 15px;
            }
            
            .login-image {
                min-height: 200px;
            }
            
            .login-form {
                padding: 2rem 1.5rem;
            }
            
            .login-title {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <div class="d-flex justify-content-center align-items-center min-vh-100 p-4">
        <div class="login-container">
            <div class="row g-0 h-100">
                <!-- Left Side - Image -->
                <div class="col-lg-6">
                    <div class="login-image h-100">
                        <div class="text-center image-overlay">
                            <!-- Optional: Tambahkan logo kecil di atas teks jika diinginkan -->
                            <img src="{{ asset('assets/images/logo.png') }}" alt="Logo" class="login-logo mb-3" style="max-width: 180px; height: auto; filter: drop-shadow(0 4px 8px rgba(0,0,0,0.3));">
                            
                            <!-- <h3 class="text-white mt-3 fw-bold" style="text-shadow: 0 2px 4px rgba(0,0,0,0.7); color: #D4AF37 !important;">
                                Welcome Back!
                            </h3> -->
                            <!-- <p class="mt-2" style="color: rgba(212, 175, 55, 0.9);">Sign in to continue shopping</p> -->
                        </div>
                    </div>
                </div>
                
                <!-- Right Side - Login Form -->
                <div class="col-lg-6">
                    <div class="login-form">
                        <div class="text-center mb-4">
                            <h2 class="login-title">Sign In</h2>
                            <p class="login-subtitle">Enter your credentials to access your account</p>
                        </div>
                        
                        @if (session('wrong'))
                            <div class="alert alert-danger" role="alert">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                {{ session('wrong') }}
                            </div>
                        @endif
                        
                        <form action="/login" method="POST">
                            @csrf
                            <div class="form-group">
                                <label class="form-label">Email or Username</label>
                                <div class="position-relative">
                                    <i class="fas fa-envelope input-icon"></i>
                                    <input type="text" 
                                           class="form-control @error('login') is-invalid @enderror @error('email') is-invalid @enderror" 
                                           name="login" 
                                           value="{{ old('login') ?? old('email') }}"
                                           placeholder="Enter your email or username"
                                           required>
                                </div>
                                @error('login')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label class="form-label">Password</label>
                                <div class="position-relative">
                                    <i class="fas fa-lock input-icon"></i>
                                    <input type="password" 
                                           class="form-control @error('password') is-invalid @enderror" 
                                           name="password"
                                           placeholder="Enter your password"
                                           required>
                                </div>
                                @error('password')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="d-grid">
                                <button type="submit" class="btn btn-login">
                                    <i class="fas fa-sign-in-alt me-2"></i>
                                    <span>Sign In</span>
                                </button>
                            </div>
                        </form>
                        
                        <!-- <div class="text-center mt-4">
                            <p class="text-muted">
                                Don't have an account? 
                                <a href="/register" class="text-decoration-none fw-semibold" style="color: #8B0000; transition: all 0.3s ease;" 
                                   onmouseover="this.style.color='#D4AF37'" 
                                   onmouseout="this.style.color='#8B0000'">
                                    Create one here
                                </a>
                            </p>
                        </div> -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
