@extends('layouts.homepage.main')

@section('content')
    <!-- Breadcrumb Start -->
    <div class="breadcrumb-area mt-30">
        <div class="container">
            <div class="breadcrumb">
                <ul class="d-flex align-items-center">
                    <li><a href="{{ route('homepage') }}">Home</a></li>
                    <li><a href="{{ route('product.order') }}">Pesanan</a></li>
                    <li class="active"><a href="javascript:void(0)">Bayar Cicilan</a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <div class="checkout-area pb-100 pt-15 pb-sm-60">
        <div class="container">
            <div class="row">
                <div class="col-lg-7 col-md-8 mx-auto">
                    <div class="checkbox-form mb-sm-40">
                        <h3>Pembayaran Cicilan</h3>
                        <div class="mb-3">
                            <table class="table table-bordered">
                                <tr>
                                    <th>Order Total</th>
                                    <td>Rp {{ number_format($order->total, 0, ',', '.') }}</td>
                                </tr>
                                <tr>
                                    <th>Cicilan per Bulan</th>
                                    <td>
                                        @if ($order->periode_cicilan)
                                            Rp
                                            {{ number_format(ceil($order->total / $order->periode_cicilan), 0, ',', '.') }}
                                            <small class="text-muted">({{ $order->periode_cicilan }} bulan)</small>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>Jumlah Telah Dibayar</th>
                                    <td>
                                        @if ($order->jumlah_pelunasan)
                                            Rp {{ number_format($order->jumlah_pelunasan, 0, ',', '.') }}
                                            <br>
                                            <small class="text-muted">
                                                {{ $order->updated_at ? $order->updated_at->format('d M Y H:i') : '' }}
                                            </small>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>Sisa Cicilan</th>
                                    <td>
                                        {!! $order->sisa_pelunasan == 0 || $order->sisa_pelunasan === null
                                            ? '<span class="text-primary">Lunas</span>'
                                            : 'Rp ' . number_format($order->sisa_pelunasan, 0, ',', '.') !!}
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <form id="cicilan-form" action="{{ route('product.bayar.cicilan', $order->id) }}"
                            enctype="multipart/form-data" method="POST">
                            @csrf

                            <div class="country-select clearfix mb-30">
                                <label>Metode Pembayaran <span class="required">*</span></label>
                                <select class="wide" name="metode_pembayaran" id="metode_pembayaran" required>
                                    <option disabled selected>-- Pilih Metode Pembayaran --</option>
                                    <option value="transfer">Transfer</option>
                                    <option value="tunai">Tunai</option>
                                </select>
                            </div>

                            <div class="checkout-form-list mt-30" id="uploadBuktiWrapper" style="display: none;">
                                <label>Upload Bukti <span class="required">*</span></label>
                                <input type="file" accept=".png, .jpg, .jpeg" name="bukti" />
                                @error('bukti')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="wc-proceed-to-checkout mt-30 d-flex justify-content-between">
                                <a href="{{ route('product.order') }}" class="btn btn-secondary">Kembali</a>
                                <button type="submit" class="btn btn-primary">Bayar Cicilan</button>
                            </div>
                        </form>

                        <div class="payment-method mt-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">
                                        <button class="btn btn-link" data-toggle="collapse" data-target="#collapseOne"
                                            aria-expanded="true" aria-controls="collapseOne">
                                            Transfer ke Bank BNI
                                        </button>
                                    </h5>
                                </div>
                                <div id="collapseOne" class="collapse show" data-parent="#accordion">
                                    <div class="card-body">
                                        <p>
                                            Pembayaran melalui <br>
                                            No. Rekening :
                                            <span id="noRek">0830 0100 3815 500 (BRI)</span>
                                            <br>
                                            Dana: 087788470428
                                            <br>
                                            Atas Nama : Meilina Suci Ardelia
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        @if (isset($histories) && count($histories))
                            <div class="mt-4">
                                <h5>Riwayat Pembayaran Cicilan</h5>
                                <table class="table table-sm table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Tanggal</th>
                                            <th>Jumlah</th>
                                            <th>Metode</th>
                                            <th>Bukti</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($histories as $h)
                                            <tr>
                                                <td>{{ $h->created_at->format('d M Y H:i') }}</td>
                                                <td>Rp {{ number_format($h->jumlah_cicilan, 0, ',', '.') }}</td>
                                                <td>{{ ucfirst($h->metode_pembayaran) }}</td>
                                                <td>
                                                    @if ($h->bukti)
                                                        <a href="{{ asset('storage/bukti_pembayaran/' . $h->bukti) }}"
                                                            target="_blank">Lihat</a>
                                                    @else
                                                        -
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            $('#uploadBuktiWrapper').hide();

            $('#metode_pembayaran').on('change', function() {
                if ($(this).val() === 'transfer') {
                    $('#uploadBuktiWrapper').show();
                } else {
                    $('#uploadBuktiWrapper').hide();
                }
            });
        });
    </script>
@endsection
