@extends('layouts.homepage.main')

@section('content')
  <!-- Breadcrumb Start -->
  <div class="breadcrumb-area mt-30">
    <div class="container">
      <div class="breadcrumb">
        <ul class="d-flex align-items-center">
          <li><a href="{{ route('homepage') }}">Home</a></li>
          <li class="active"><a href="javascript:void(0)">Cart</a></li>
        </ul>
      </div>
    </div>
    <!-- Container End -->
  </div>
  <!-- Breadcrumb End -->
  <!-- Cart Main Area Start -->
  <div class="cart-main-area ptb-100 ptb-sm-60">
    <div class="container">
      <div class="row">
        <div class="col-md-12 col-sm-12">
          <!-- Form Start -->
          <form action="#">
            <!-- Table Content Start -->
            <div class="table-content table-responsive mb-45">
              <table>
                <thead>
                  <tr>
                    <th class="product-thumbnail">Image</th>
                    <th class="product-name">Product</th>
                    <th class="product-price">Price</th>
                    <th class="product-quantity">Quantity</th>
                    <th class="product-subtotal">Total</th>
                    <th class="product-remove">Remove</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($cartItems as $ci)
                    <tr>
                      <td class="product-thumbnail">
                        <a href="{{ route('product.detail', $ci->produk->id) }}"><img
                            src="{{ asset('storage/foto_produk/' . $ci->produk->foto_produk) }}" alt="cart-image" /></a>
                      </td>
                      <td class="product-name"><a href="{{ route('product.detail', $ci->produk->id) }}">{{ $ci->produk->nama_produk }}</a></td>
                      <td class="product-price"><span class="amount">Rp{{ number_format($ci->produk->harga_produk, 0, ',', '.') }}</span></td>
                      <td class="product-quantity">
                        <input type="number" class="cart-qty" data-id="{{ $ci->produk->id }}"
                          data-update-url="{{ route('product.update.cart', $ci->produk->id) }}" value="{{ $ci->quantity }}" min="1" />
                      </td>
                      <td class="product-subtotal"><span
                          class="amount">Rp{{ number_format($ci->produk->harga_produk * $ci->quantity, 0, ',', '.') }}</span></td>
                      <td class="product-remove">
                        <a href="javascript:void(0)" class="remove-cart-item" data-url="{{ route('product.remove.cart', $ci->produk->id) }}"
                          data-id="{{ $ci->produk->id }}">
                          <i class="fa fa-times" aria-hidden="true"></i>
                        </a>
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
            <!-- Table Content Start -->
            <div class="row">
              <!-- Cart Button Start -->
              <div class="col-md-8 col-sm-12">
                <div class="buttons-cart">
                  <a href="{{ route('homepage') }}">Continue Shopping</a>
                </div>
              </div>
              <!-- Cart Button Start -->
              <!-- Cart Totals Start -->
              <div class="col-md-4 col-sm-12">
                <div class="cart_totals float-md-right text-md-right">
                  <h2>Cart Totals</h2>
                  <br />
                  <table class="float-md-right">
                    <tbody>
                      <tr class="order-total">
                        <th>Total</th>
                        <td>
                          <strong><span class="amount">Rp {{ number_format($totalPrice, 0, ',', '.') }}</span></strong>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                  <div class="wc-proceed-to-checkout">
                    <a href="{{ route('product.checkout') }}">Proceed to Checkout</a>
                  </div>
                </div>
              </div>
              <!-- Cart Totals End -->
            </div>
            <!-- Row End -->
          </form>
          <!-- Form End -->
        </div>
      </div>
      <!-- Row End -->
    </div>
  </div>
  <!-- Cart Main Area End -->
@endsection

@section('script')
  <script>
    $(document).ready(function() {

      // 🔁 UPDATE QTY via AJAX
      $('.cart-qty').on('change', function() {
        const $input = $(this);
        const url = $input.data('update-url');
        const quantity = $input.val();

        $.ajax({
          url: url,
          method: 'POST',
          data: {
            _token: '{{ csrf_token() }}',
            quantity: quantity
          },
          success: function(res) {
            location.reload(); // Optional: reload untuk update total
          },
          error: function() {
            Swal.fire("Error", "Gagal mengubah jumlah produk.", "error");
          }
        });
      });

      // ❌ HAPUS PRODUK dari Cart via AJAX
      $('.remove-cart-item').on('click', function(e) {
        e.preventDefault();

        const $btn = $(this);
        const url = $btn.data('url');
        const rowId = $btn.data('id');

        $.ajax({
          url: url,
          method: 'DELETE',
          data: {
            _token: '{{ csrf_token() }}'
          },
          success: function(res) {
            // Hapus baris dari DOM
            $btn.closest('tr').fadeOut(300, function() {
              $(this).remove();
              // Optionally update total
              location.reload(); // Atau: update total price manual tanpa reload
            });
          },
          error: function() {
            Swal.fire("Error", "Gagal menghapus produk.", "error");
          }
        });
      });

    });
  </script>
@endsection
