@extends('layouts.homepage.main')

@section('content')
    <!-- Breadcrumb Start -->
    <div class="breadcrumb-area mt-30">
        <div class="container">
            <div class="breadcrumb">
                <ul class="d-flex align-items-center">
                    <li><a href="{{ route('homepage') }}">Home</a></li>
                    <li class="active"><a href="javascript:void(0)">Checkout</a></li>
                </ul>
            </div>
        </div>
        <!-- Container End -->
    </div>
    <!-- Breadcrumb End -->
    <!-- checkout-area start -->
    <div class="checkout-area pb-100 pt-15 pb-sm-60">
        <div class="container">
            @if ($errors->has('error'))
                <div class="alert alert-danger">
                    {{ $errors->first('error') }}
                </div>
            @endif
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <div class="checkbox-form mb-sm-40">
                        <h3>Shipping Details</h3>
                        <div class="row">
                            <form id="checkout-form" action="{{ route('product.create.order') }}"
                                enctype="multipart/form-data" method="POST">
                                @csrf
                                <div class="col-md-12">
                                    <div class="checkout-form-list mb-30">
                                        <label>Name <span class="required">*</span></label>
                                        <input type="text" name="name" value="{{ Auth::user()->name ?? '' }}"
                                            placeholder="Full name" required />
                                        @error('name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="checkout-form-list mb-30">
                                        <label>Email <span class="required">*</span></label>
                                        <input type="email" name="email" value="{{ Auth::user()->email ?? '' }}"
                                            placeholder="Your email" required />
                                        @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="checkout-form-list mb-30">
                                        <label>Phone <span class="required">*</span></label>
                                        <input type="text" name="phone"
                                            value="{{ Auth::user()->pelanggan->phone ?? '' }}" placeholder="08123xxx"
                                            required />
                                        @error('phone')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12 order-notes">
                                    <div class="checkout-form-list mb-30">
                                        <label>Address <span class="required">*</span></label>
                                        <textarea id="checkout-mess" cols="30" rows="10" name="alamat_pelanggan"
                                            placeholder="Contoh: Jl. Merdeka No. 45, RT 03 RW 07, Kelurahan Sukamaju, Kecamatan Kebon Jeruk, Kota Jakarta Barat"
                                            required>{{ Auth::user()->pelanggan->alamat_pelanggan ?? '' }}</textarea>
                                        @error('alamat_pelanggan')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <!-- Metode Bayar -->
                                <div class="col-md-12">
                                    <div class="country-select clearfix mb-30">
                                        <label>Metode Bayar <span class="required">*</span></label>
                                        <select class="wide" name="metode_bayar" id="metode_bayar" required>
                                            <option disabled selected>-- Pilih Metode Bayar --</option>
                                            <option value="cicilan">Cicilan</option>
                                            <option value="lunas">Lunas</option>
                                        </select>
                                    </div>
                                </div>
                                <!-- Jumlah Bayar -->
                                {{-- <div class="col-md-12" id="jumlahBayarWrapper" style="display: none;">
                                    <div class="checkout-form-list mb-30">
                                        <label>Jumlah Bayar <span class="required">*</span></label>
                                        <input type="text" id="jumlah_pelunasan" name="jumlah_pelunasan"
                                            placeholder="Contoh: 50000" />
                                    </div>
                                </div> --}}

                                <!-- Pilihan periode cicilan -->
                                <div class="col-md-12" id="periodeCicilanWrapper" style="display: none;">
                                    <div class="checkout-form-list mb-30">
                                        <label>Periode Cicilan <span class="required">*</span></label>
                                        <select id="periode_cicilan" name="periode_cicilan" class="wide">
                                            <option value="3">3 Bulan</option>
                                            <option value="6">6 Bulan</option>
                                            <option value="12">12 Bulan</option>
                                        </select>
                                        <p class="mt-2" id="previewJumlahCicilan" class="text-muted"></p>
                                    </div>
                                </div>

                                <!-- Metode Pembayaran -->
                                <div class="col-md-12">
                                    <div class="country-select clearfix mb-30">
                                        <label>Metode Pembayaran <span class="required">*</span></label>
                                        <select class="wide" name="metode_pembayaran" id="metode_pembayaran" required>
                                            <option disabled selected>-- Pilih Metode Pembayaran --</option>
                                            <option value="transfer">Transfer</option>
                                            <option value="tunai">Tunai</option>
                                        </select>
                                    </div>
                                </div>
                                <!-- Upload Bukti -->
                                <div class="col-md-12" id="uploadBuktiWrapper" style="display: none;">
                                    <div class="checkout-form-list mt-30">
                                        <label>Upload Bukti <span class="required">*</span></label>
                                        <input type="file" accept=".png, .jpg, .jpeg" name="bukti" />
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="wc-proceed-to-checkout mt-30 d-flex justify-content-center">
                        <a href="javascript:void(0)" onclick="submitCheckout()">Place Order</a>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="your-order">
                        <h3>Your order</h3>
                        <div class="your-order-table table-responsive">
                            <table>
                                <thead>
                                    <tr>
                                        <th class="product-name">Product</th>
                                        <th class="product-total">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($cartItems as $ci)
                                        <tr class="cart_item">
                                            <td class="product-name">
                                                {{ $ci->produk->nama_produk }}
                                                <span class="product-quantity"> × {{ $ci->quantity }}</span>
                                            </td>
                                            <td class="product-total">
                                                <span
                                                    class="amount">Rp{{ number_format($ci->produk->harga_produk * $ci->quantity, 0, ',', '.') }}</span>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    {{-- <tr class="cart-subtotal">
                    <th>Cart Subtotal</th>
                    <td><span class="amount">£215.00</span></td>
                  </tr> --}}
                                    <tr class="order-total">
                                        <th>Order Total</th>
                                        <td><span
                                                class=" total amount">Rp{{ number_format($totalPrice, 0, ',', '.') }}</span>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="payment-method">
                            <div id="accordion">
                                <div class="card">
                                    <div class="card-header" id="headingone">
                                        <h5 class="mb-0">
                                            <button class="btn btn-link" data-toggle="collapse"
                                                data-target="#collapseOne" aria-expanded="true"
                                                aria-controls="collapseOne">
                                                Transfer ke Bank BNI
                                            </button>
                                        </h5>
                                    </div>

                                    <div id="collapseOne" class="collapse show" aria-labelledby="headingone"
                                        data-parent="#accordion">
                                        <div class="card-body">
                                            <p>
                                                Pembayaran melalui <br><br>
                                                No. Rekening :
                                                <span id="noRek">0830 0100 3815 500 (BRI)</span>

                                                <br>
                                                Dana: 087788470428
                                                <br>
                                                Atas Nama : Meilina Suci Ardelia
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- checkout-area end -->
@endsection

@section('script')
    <script>
        @if (Auth::check() && Auth::user()->ada_hutang == 1)
            Swal.fire({
                icon: 'error',
                title: 'Checkout Diblokir',
                text: 'Lunasi pesanan sebelumnya terlebih dahulu sebelum checkout!',
                allowOutsideClick: false,
                allowEscapeKey: false,
            }).then(() => {
                window.location.href = '{{ route('product.cart') }}';
            });
        @endif

        const btnCopy = document.getElementById("btnCopy");
        if (btnCopy) {
            btnCopy.addEventListener("click", function() {
                const noRek = document.getElementById("noRek").textContent.trim();

                // Salin ke clipboard
                navigator.clipboard.writeText(noRek).then(function() {
                    Swal.fire({
                        icon: "success",
                        title: "Berhasil",
                        text: "No. rekening berhasil disalin: " + noRek,
                        timer: 4000
                    })
                }, function(err) {
                    Swal.fire({
                        icon: "error",
                        title: "Gagal",
                        text: "Gagal menyalin no. rekening: " + err,
                        timer: 4000
                    })
                });
            });
        }

        $(document).ready(function() {
            // Sembunyikan awal
            $('#jumlahBayarWrapper').hide();
            $('#uploadBuktiWrapper').hide();

            function toggleFields() {
                // Kondisi Jumlah Bayar: sembunyikan jika metode bayar = lunas
                const metodeBayar = $('#metode_bayar').val();
                // if (metodeBayar === 'lunas') {
                //     $('#jumlahBayarWrapper').hide();
                // } else if (metodeBayar === 'cicilan') {
                //     $('#jumlahBayarWrapper').show();
                // }
                if (metodeBayar === 'cicilan') {
                    $('#jumlahBayarWrapper').hide();
                    $('#periodeCicilanWrapper').show();

                    $('#periode_cicilan').on('change', hitungPreviewCicilan);

                    hitungPreviewCicilan();
                } else {
                    $('#periodeCicilanWrapper').hide();
                }

                // Kondisi Upload Bukti: sembunyikan jika metode pembayaran = tunai
                const metodePembayaran = $('#metode_pembayaran').val();
                if (metodePembayaran === 'tunai') {
                    $('#uploadBuktiWrapper').hide();
                } else if (metodePembayaran === 'transfer') {
                    $('#uploadBuktiWrapper').show();
                }
            }

            function hitungPreviewCicilan() {
                const total = {{ $totalPrice }};
                const periode = $('#periode_cicilan').val();
                if (periode) {
                    const cicilan = Math.ceil(total / periode);
                    $('#previewJumlahCicilan').text(
                        `Perkiraan cicilan per bulan: Rp${cicilan.toLocaleString('id-ID')}`);
                } else {
                    $('#previewJumlahCicilan').text('');
                }
            }

            // Jalankan saat halaman pertama kali load
            toggleFields();

            // Jalankan setiap kali ada perubahan
            $('#metode_bayar, #metode_pembayaran').on('change', toggleFields);
        });

        $(document).ready(function() {
            // Format input jadi rupiah saat diketik
            $('#jumlah_pelunasan').on('keyup', function() {
                let input = $(this).val().replace(/[^,\d]/g, '').toString();
                let split = input.split(',');
                let sisa = split[0].length % 3;
                let rupiah = split[0].substr(0, sisa);
                let ribuan = split[0].substr(sisa).match(/\d{3}/gi);

                if (ribuan) {
                    let separator = sisa ? '.' : '';
                    rupiah += separator + ribuan.join('.');
                }

                rupiah = split[1] !== undefined ? rupiah + ',' + split[1] : rupiah;
                $(this).val('Rp ' + rupiah);
            });
        });

        function submitCheckout() {
            let input = document.getElementById('jumlah_pelunasan');
            if (input) {
                input.value = input.value.replace(/[^0-9]/g, '');
            }
            document.getElementById('checkout-form').submit();
        }
    </script>
@endsection
