@extends('layouts.homepage.main')

@section('slider')
    <div class="slider_box">
        <div class="slider-wrapper theme-default">
            <!-- Slider Background  Image Start-->
            <div id="slider" class="nivoSlider">
                <a href="javascript:void(0)"><img src="{{ asset('assets/homepage/img/slider/slider1.jpg') }}"
                        data-thumb="{{ asset('assets/homepage/img/slider/slider1.jpg') }}" alt=""
                        title="#htmlcaption" />
                </a>
                {{-- <a href="javascript:void(0)"><img src="{{ asset('assets/homepage/img/slider/slider2.jpg') }}"
            data-thumb="{{ asset('assets/homepage/img/slider/slider2.jpg') }}" alt="" title="#htmlcaption2" />
        </a> --}}
            </div>
            <!-- Slider Background  Image Start-->
        </div>
    </div>
@endsection

@section('content')
    @if (isset($products_best))
        <!-- Best Selling Products Start Here -->
        <div class="trendig-product pb-10 off-white-bg">
            <div class="container">
                <div class="trending-box">
                    <div class="title-box">
                        <h2>Best Seller</h2>
                    </div>
                    <div class="product-list-box">
                        <!-- Arrivals Product Activation Start Here -->
                        <div class="trending-pro-active owl-carousel">
                            @foreach ($products_best as $p)
                                <!-- Single Product Start -->
                                <div class="single-product">
                                    <!-- Product Image Start -->
                                    <div class="pro-img">
                                        <a href="{{ route('product.detail', $p->id) }}">
                                            <img class="primary-img"
                                                src="{{ $p->foto_produk ? asset('storage/foto_produk/' . $p->foto_produk) : asset('storage/foto_produk/default.jpg') }}"
                                                alt="single-product">
                                            {{-- <img class="secondary-img" src="assets/homepage/img/products/p1.png" alt="single-product"> --}}
                                        </a>
                                        <a href="#" class="quick_view" data-toggle="modal" data-target="#myModal"
                                            title="Quick View"><i class="lnr lnr-magnifier"></i></a>
                                    </div>
                                    <!-- Product Image End -->
                                    <!-- Product Content Start -->
                                    <div class="pro-content">
                                        <div class="pro-info">
                                            <h4><a href="product.html">{{ $p->nama_produk }}</a></h4>
                                            <p><span
                                                    class="price">Rp{{ number_format($p->harga_produk, 0, ',', '.') }}</span>
                                                {{-- <del class="prev-price">$330.50</del> --}}</p>
                                            {{-- <div class="label-product l_sale">15<span class="symbol-percent">%</span></div> --}}
                                        </div>
                                        <div class="pro-actions">
                                            <div class="actions-primary">
                                                @if (Auth::check() && Auth::user()->ada_hutang == 1)
                                                    <a href="javascript:void(0)"
                                                        onclick="Swal.fire({ icon: 'error', text: 'Lunasi pesanan sebelumnya terlebih dahulu untuk melanjutkan pembelian!' })"
                                                        class="blocked-add" title="Add to Cart">
                                                        + Add To Cart
                                                    </a>
                                                @elseif (Auth::check())
                                                    <a href="javascript:void(0)" class="add-to-cart"
                                                        data-url="{{ route('product.add.cart', $p->id) }}"
                                                        title="Add to Cart">
                                                        + Add To Cart
                                                    </a>
                                                @else
                                                    <a href="{{ route('product.cart') }}" class="add-to-cart"
                                                        title="Add to Cart">
                                                        + Add To Cart
                                                    </a>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Product Content End -->
                                </div>
                                <!-- Single Product End -->
                            @endforeach
                        </div>
                        <div class="mt-2 d-flex justify-content-center">
                            {{ $products_best->links() }}
                        </div>
                        <!-- Arrivals Product Activation End Here -->
                    </div>
                    <!-- main-product-tab-area-->
                </div>
            </div>
            <!-- Container End -->
        </div>
        <!-- Best Selling Products End Here -->
    @endif

    <!-- All Products Start Here -->
    <div class="product pb-100 off-white-bg pb-sm-60">
        <div class="container">
            {{-- <div class="trending-box"> --}}
            {{-- <div class="title-box">
          <h2>Best Selling</h2>
        </div> --}}
            <div class="product-list-box">
                <!-- Arrivals Product Activation Start Here -->
                <div class="trending-pro-active owl-carousel">
                    @foreach ($products as $p)
                        <!-- Single Product Start -->
                        <div class="single-product">
                            <!-- Product Image Start -->
                            <div class="pro-img">
                                <a href="{{ route('product.detail', $p->id) }}">
                                    <img class="primary-img"
                                        src="{{ $p->foto_produk ? asset('storage/foto_produk/' . $p->foto_produk) : asset('storage/foto_produk/default.jpg') }}"
                                        alt="single-product">
                                </a>
                                <a href="#" class="quick_view" data-toggle="modal" data-target="#myModal"
                                    title="Quick View"><i class="lnr lnr-magnifier"></i></a>
                            </div>
                            <!-- Product Image End -->
                            <!-- Product Content Start -->
                            <div class="pro-content">
                                <div class="pro-info">
                                    <h4><a href="{{ route('product.detail', $p->id) }}">{{ $p->nama_produk }}</a></h4>
                                    <p><span class="price">Rp{{ number_format($p->harga_produk, 0, ',', '.') }}</span></p>
                                </div>
                                <div class="pro-actions">
                                    <div class="actions-primary">
                                        @if (Auth::check() && Auth::user()->ada_hutang == 1)
                                            <a href="javascript:void(0)"
                                                onclick="Swal.fire({ icon: 'error', text: 'Lunasi pesanan sebelumnya terlebih dahulu untuk melanjutkan pembelian!' })"
                                                class="blocked-add" title="Add to Cart">
                                                + Add To Cart
                                            </a>
                                        @elseif (Auth::check())
                                            <a href="javascript:void(0)" class="add-to-cart"
                                                data-url="{{ route('product.add.cart', $p->id) }}" title="Add to Cart">
                                                + Add To Cart
                                            </a>
                                        @else
                                            <a href="{{ route('product.cart') }}" class="add-to-cart" title="Add to Cart">
                                                + Add To Cart
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <!-- Product Content End -->
                        </div>
                        <!-- Single Product End -->
                    @endforeach
                </div>
                <div class="mt-2 d-flex justify-content-center">
                    {{ $products->links() }}
                </div>
                <!-- Arrivals Product Activation End Here -->
            </div>
            <!-- main-product-tab-area-->
            {{-- </div> --}}
        </div>
        <!-- Container End -->
    </div>
    <!-- All Products End Here -->
@endsection

@if (Auth::check())
    @section('script')
        <script>
            $(document).ready(function() {
                $('.add-to-cart, .add-to-cart-best').click(function(e) {
                    e.preventDefault();


                    const $this = $(this);
                    const productId = $this.data('id');
                    let url = $(this).data('url');

                    $.ajax({
                        url: url,
                        method: 'POST',
                        data: {
                            _token: '{{ csrf_token() }}',
                        },
                        success: function(response) {
                            Swal.fire({
                                icon: "success",
                                text: response.message,
                                timer: 4000,
                            });

                            $('.keranjang-kosong').remove();

                            if (response.cartCount !== undefined) {
                                $('#cart-count').text(response.cartCount);
                            }

                            updateCart(response.cartItems, response.total);
                        },
                        error: function(xhr) {
                            if (xhr.status === 403) {
                                Swal.fire({
                                    icon: "warning",
                                    title: "Pesanan Tertunda",
                                    text: xhr.responseJSON.message,
                                    confirmButtonText: "OK"
                                });
                            } else {
                                Swal.fire({
                                    icon: "error",
                                    title: "Error",
                                    text: xhr.responseJSON?.message ||
                                        'Terjadi kesalahan saat menambahkan item',
                                    timer: 4000,
                                });
                            }
                        }
                    });
                });

                function updateCart(cartItems, total) {
                    const wrapper = $('.cart-items-wrapper');
                    const footer = $('.cart-footer');
                    wrapper.empty();
                    footer.empty();

                    if (cartItems.length === 0) {
                        wrapper.append('<p class="text-center">Keranjang kosong</p>');
                        return;
                    }

                    cartItems.forEach(function(item) {
                        const html = `
                    <div class="single-cart-box" id="cart-item-${item.id}">
                        <div class="cart-img">
                            <a href="${item.detail_url}">
                                <img src="${item.foto}" alt="cart-image">
                            </a>
                            <span class="pro-quantity">${item.quantity}</span>
                        </div>
                        <div class="cart-content">
                            <h6><a href="${item.detail_url}">${item.nama}</a></h6>
                            <span class="cart-price">Rp${item.harga}</span>
                        </div>
                        <a href="javascript:void(0)" class="del-icone remove-item"
                            data-id="${item.id}" data-urlcart="${item.remove_url}">
                            <i class="ion-close"></i>
                        </a>
                    </div>`;
                        wrapper.append(html);
                    });

                    wrapper.append(`
                <div class="cart-footer">
                    <ul class="price-content">
                        <li>Total <span id="cart-total-price">Rp${total}</span></li>
                    </ul>
                    <div class="cart-actions text-center">
                        <a class="cart-checkout" href="{{ route('product.checkout') }}">Checkout</a>
                    </div>
                </div>
            `);
                }
            });
        </script>
    @endsection
@endif
