@extends('layouts.homepage.main')

@section('content')
    <!-- Breadcrumb Start -->
    <div class="breadcrumb-area mt-30">
        <div class="container">
            <div class="breadcrumb">
                <ul class="d-flex align-items-center">
                    <li><a href="{{ route('homepage') }}">Home</a></li>
                    <li class="active"><a href="javascript:void(0)">Pesanan</a></li>
                </ul>
            </div>
        </div>
        <!-- Container End -->
    </div>
    <!-- Breadcrumb End -->
    <!-- Cart Main Area Start -->
    <div class="cart-main-area ptb-100 ptb-sm-60">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-sm-12">
                    <!-- Form Start -->
                    {{-- <form action="#"> --}}
                    <div class="order-filter-tabs mb-4">
                        <div class="order-filter-tabs mb-4">
                            <ul class="nav nav-tabs justify-content-center border-bottom border-1"
                                style="gap: 20px; font-weight: 500;">
                                <li class="nav-item">
                                    <a class="nav-link {{ request('status') == null ? 'text-danger border-bottom border-danger' : '' }}"
                                        href="{{ route('product.order') }}">Semua</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link {{ request('status') == 'belum bayar' ? 'text-danger border-bottom border-danger' : '' }}"
                                        href="{{ route('product.order', ['status' => 'belum bayar']) }}">Belum Bayar</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link {{ request('status') == 'dikemas' ? 'text-danger border-bottom border-danger' : '' }}"
                                        href="{{ route('product.order', ['status' => 'dikemas']) }}">Sedang Dikemas</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link {{ request('status') == 'dikirim' ? 'text-danger border-bottom border-danger' : '' }}"
                                        href="{{ route('product.order', ['status' => 'dikirim']) }}">Dikirim</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link {{ request('status') == 'selesai' ? 'text-danger border-bottom border-danger' : '' }}"
                                        href="{{ route('product.order', ['status' => 'selesai']) }}">Selesai</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link {{ request('status') == 'dibatalkan' ? 'text-danger border-bottom border-danger' : '' }}"
                                        href="{{ route('product.order', ['status' => 'dibatalkan']) }}">Dibatalkan</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link {{ request('status') == 'pengembalian' ? 'text-danger border-bottom border-danger' : '' }}"
                                        href="{{ route('product.order', ['status' => 'pengembalian']) }}">Pengembalian
                                        Barang</a>
                                </li>
                            </ul>
                        </div>
                        <!-- Table Content Start -->
                        <div class="table-content table-responsive mb-45">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Order Date</th>
                                        <th>Image</th>
                                        <th>Product</th>
                                        <th>Price</th>
                                        <th>Quantity</th>
                                        <th>Subtotal</th>
                                        <th>Order Total</th>
                                        <th>Status Pembayaran</th>
                                        <th>Detail Pembayaran</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {{-- ...existing code... --}}
                                    @foreach ($orders as $o)
                                        @foreach ($o->products as $index => $product)
                                            @php
                                                $isFirst = $index === 0;
                                                $isLast = $index === $o->products->count() - 1;
                                                $borderStyle = '';
                                                if ($isFirst) {
                                                    $borderStyle .= 'border-top: 3px solid #000;';
                                                }
                                                if ($isLast) {
                                                    $borderStyle .= 'border-bottom: 3px solid #000;';
                                                }
                                            @endphp

                                            <tr style="{{ $borderStyle }}">
                                                @if ($isFirst)
                                                    <td rowspan="{{ $o->products->count() }}">
                                                        {{ $o->created_at->format('d M Y H:i') }}
                                                    </td>
                                                @endif
                                                <td>
                                                    <img src="{{ asset('storage/foto_produk/' . $product->foto_produk) }}"
                                                        width="50" alt="{{ $product->nama_produk }}">
                                                </td>
                                                <td>{{ $product->nama_produk }}</td>
                                                <td>Rp {{ number_format($product->pivot->harga_produk, 0, ',', '.') }}</td>
                                                <td>{{ $product->pivot->quantity }}</td>
                                                <td>Rp
                                                    {{ number_format($product->pivot->harga_produk * $product->pivot->quantity, 0, ',', '.') }}
                                                </td>
                                                @if ($isFirst)
                                                    <td rowspan="{{ $o->products->count() }}">
                                                        Rp
                                                        {{ number_format($o->products->sum(fn($p) => $p->pivot->harga_produk * $p->pivot->quantity), 0, ',', '.') }}
                                                    </td>
                                                @endif
                                                @if ($isFirst)
                                                    <td rowspan="{{ $o->products->count() }}">
                                                        @if ($o->total == $o->jumlah_pelunasan)
                                                            <span class="text-primary fw-bold"> LUNAS </span>
                                                        @else
                                                            <span class="text-danger fw-bold"> -
                                                                {{ number_format($o->sisa_pelunasan, 0, ',', '.') }}
                                                            </span>
                                                        @endif
                                                    </td>
                                                    <td rowspan="{{ $o->products->count() }}">
                                                        <button type="button" class="btn btn-primary shadow-none"
                                                            data-toggle="modal"
                                                            data-target="#data-order-homepage{{ $o->id }}"><i
                                                                class="fa fa-info"></i></button>
                                                        <div class="modal fade" id="data-order-homepage{{ $o->id }}"
                                                            tabindex="-1" aria-labelledby="exampleModalLabel"
                                                            aria-hidden="true">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title">Informasi Pembayaran</h5>
                                                                        <button type="button" class="close"
                                                                            data-dismiss="modal" aria-label="Close">
                                                                            <span aria-hidden="true">&times;</span>
                                                                        </button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        <table>
                                                                            <tr>
                                                                                <td> Order Total </td>
                                                                                <td>{{ $o->total !== null ? 'Rp ' . number_format($o->total, 0, ',', '.') : '-' }}
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td> Jumlah telah dibayar </td>
                                                                                <td>{{ $o->jumlah_pelunasan !== null ? 'Rp ' . number_format($o->jumlah_pelunasan, 0, ',', '.') : '-' }}
                                                                            </tr>
                                                                            <tr>
                                                                                <td> Sisa Cicilan </td>
                                                                                <td>
                                                                                    {!! $o->sisa_pelunasan == 0 || $o->sisa_pelunasan === null
                                                                                        ? '<span class="text-primary">Lunas</span>'
                                                                                        : 'Rp ' . number_format($o->sisa_pelunasan, 0, ',', '.') !!}
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div
                                                                        class="modal-footer d-flex justify-content-between">
                                                                        <button type="button" class="btn btn-secondary"
                                                                            data-dismiss="modal">Kembali</button>
                                                                        @if ($o->sisa_pelunasan > 0)
                                                                            <a href="{{ route('product.bayar.cicilan.form', $o->id) }}"
                                                                                class="btn btn-success">
                                                                                Bayar Cicilan
                                                                            </a>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                @endif
                                                @if ($isFirst)
                                                    <td rowspan="{{ $o->products->count() }}">
                                                        @if ($o->status == 'dikemas')
                                                            <span
                                                                class="badge bg-secondary text-white">{{ ucfirst($o->status) }}</span>
                                                        @elseif($o->status == 'dikirim')
                                                            <span
                                                                class="badge bg-primary text-white">{{ ucfirst($o->status) }}</span>
                                                            <br><br>
                                                            <button type="button" class="btn btn-success mt-2"
                                                                data-toggle="modal"
                                                                data-target="#terimaPesananModal{{ $o->id }}">
                                                                Terima Pesanan
                                                            </button>

                                                            <!-- Modal -->
                                                            <div class="modal fade"
                                                                id="terimaPesananModal{{ $o->id }}" tabindex="-1"
                                                                role="dialog"
                                                                aria-labelledby="modalLabel{{ $o->id }}"
                                                                aria-hidden="true">
                                                                <div class="modal-dialog" role="document">
                                                                    <form
                                                                        action="{{ route('pelacakan.customer.terima', $o->id) }}"
                                                                        method="POST" enctype="multipart/form-data">
                                                                        @csrf
                                                                        @method('PUT')
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h5 class="modal-title">Konfirmasi Terima
                                                                                    Pesanan</h5>
                                                                                <button type="button" class="close"
                                                                                    data-dismiss="modal"
                                                                                    aria-label="Close"><span
                                                                                        aria-hidden="true">&times;</span></button>
                                                                            </div>
                                                                            <div class="modal-body">
                                                                                <p>Upload foto sebagai bukti bahwa Anda
                                                                                    telah menerima pesanan ini.</p>
                                                                                <div class="form-group">
                                                                                    <label for="bukti_penerimaan">Bukti
                                                                                        Penerimaan</label>
                                                                                    <input type="file"
                                                                                        name="bukti_penerimaan"
                                                                                        class="form-control" required
                                                                                        accept=".jpg,.jpeg,.png">
                                                                                </div>
                                                                            </div>
                                                                            <div class="modal-footer">
                                                                                <button type="button"
                                                                                    class="btn btn-secondary"
                                                                                    data-dismiss="modal">Batal</button>
                                                                                <button type="submit"
                                                                                    class="btn btn-primary">Kirim</button>
                                                                            </div>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        @elseif($o->status == 'selesai')
                                                            <span
                                                                class="badge bg-success text-white">{{ ucfirst($o->status) }}</span>
                                                        @elseif($o->status == 'dibatalkan')
                                                            <span
                                                                class="badge bg-danger text-white">{{ ucfirst($o->status) }}</span>
                                                        @endif
                                                    </td>
                                                @endif
                                            </tr>
                                        @endforeach
                                    @endforeach
                                    {{-- ...existing code... --}}
                                </tbody>
                            </table>
                        </div>
                        <!-- Table Content Start -->
                        <div class="row">
                            <!-- Cart Button Start -->
                            <div class="col-md-8 col-sm-12">
                                <div class="buttons-cart">
                                    <a href="{{ route('homepage') }}">Continue Shopping</a>
                                </div>
                            </div>
                            <!-- Cart Button Start -->
                        </div>
                        <!-- Row End -->
                    </div>
                    {{-- </form> --}}
                    <!-- Form End -->
                </div>
            </div>
            <!-- Row End -->
        </div>
    </div>
    <!-- Cart Main Area End -->
@endsection

@section('script')
    <script>
        $(document).ready(function() {

            // 🔁 UPDATE QTY via AJAX
            $('.cart-qty').on('change', function() {
                const $input = $(this);
                const url = $input.data('update-url');
                const quantity = $input.val();

                $.ajax({
                    url: url,
                    method: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        quantity: quantity
                    },
                    success: function(res) {
                        location.reload(); // Optional: reload untuk update total
                    },
                    error: function() {
                        Swal.fire("Error", "Gagal mengubah jumlah produk.", "error");
                    }
                });
            });

            // ❌ HAPUS PRODUK dari Cart via AJAX
            $('.remove-cart-item').on('click', function(e) {
                e.preventDefault();

                const $btn = $(this);
                const url = $btn.data('url');
                const rowId = $btn.data('id');

                $.ajax({
                    url: url,
                    method: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(res) {
                        // Hapus baris dari DOM
                        $btn.closest('tr').fadeOut(300, function() {
                            $(this).remove();
                            // Optionally update total
                            location
                                .reload(); // Atau: update total price manual tanpa reload
                        });
                    },
                    error: function() {
                        Swal.fire("Error", "Gagal menghapus produk.", "error");
                    }
                });
            });

        });
    </script>
@endsection
