@extends('layouts.homepage.main')

@section('content')
  <!-- Breadcrumb Start -->
  <div class="breadcrumb-area mt-30">
    <div class="container">
      <div class="breadcrumb">
        <ul class="d-flex align-items-center">
          <li><a href="{{ route('homepage') }}">Home</a></li>
          <li class="active"><a href="javascript:void(0)">Products</a></li>
        </ul>
      </div>
    </div>
    <!-- Container End -->
  </div>
  <!-- Breadcrumb End -->
  <!-- Product Thumbnail Start -->
  <div class="main-product-thumbnail ptb-100 ptb-sm-60">
    <div class="container">
      <div class="thumb-bg">
        <div class="row">
          <!-- Main Thumbnail Image Start -->
          <div class="col-lg-5 mb-all-40">
            <!-- Thumbnail Large Image start -->
            <div class="tab-content">
              <div id="thumb1" class="tab-pane fade show active">
                <a data-fancybox="images" href="{{ asset('/storage/foto_produk/' . $product->foto_produk) }}"><img
                    src="{{ asset('/storage/foto_produk/' . $product->foto_produk) }}" alt="product-view"></a>
              </div>
              {{-- <div id="thumb2" class="tab-pane fade">
                <a data-fancybox="images" href="img/products/13.jpg"><img src="img/products/13.jpg" alt="product-view"></a>
              </div>
              <div id="thumb3" class="tab-pane fade">
                <a data-fancybox="images" href="img/products/15.jpg"><img src="img/products/15.jpg" alt="product-view"></a>
              </div>
              <div id="thumb4" class="tab-pane fade">
                <a data-fancybox="images" href="img/products/4.jpg"><img src="img/products/4.jpg" alt="product-view"></a>
              </div>
              <div id="thumb5" class="tab-pane fade">
                <a data-fancybox="images" href="img/products/5.jpg"><img src="img/products/5.jpg" alt="product-view"></a>
              </div> --}}
            </div>
            <!-- Thumbnail Large Image End -->
            <!-- Thumbnail Image End -->
            <div class="product-thumbnail mt-15">
              <div class="thumb-menu owl-carousel nav tabs-area" role="tablist">
                <a class="active" data-toggle="tab" href="#thumb1"><img src="{{ asset('/storage/foto_produk/' . $product->foto_produk) }}"
                    alt="product-thumbnail"></a>
                {{-- <a data-toggle="tab" href="#thumb2"><img src="img/products/13.jpg" alt="product-thumbnail"></a>
                <a data-toggle="tab" href="#thumb3"><img src="img/products/15.jpg" alt="product-thumbnail"></a>
                <a data-toggle="tab" href="#thumb4"><img src="img/products/4.jpg" alt="product-thumbnail"></a>
                <a data-toggle="tab" href="#thumb5"><img src="img/products/5.jpg" alt="product-thumbnail"></a> --}}
              </div>
            </div>
            <!-- Thumbnail image end -->
          </div>
          <!-- Main Thumbnail Image End -->
          <!-- Thumbnail Description Start -->
          <div class="col-lg-7">
            <div class="thubnail-desc fix">
              <h3 class="product-header">{{ $product->nama_produk }}</h3>
              <div class="rating-summary fix mtb-10">
                <div class="rating">
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star-o"></i>
                </div>
                <div class="rating-feedback">
                  <a href="#">(1 review)</a>
                  <a href="#">add to your review</a>
                </div>
              </div>
              <div class="pro-price mtb-30">
                <p class="d-flex align-items-center">
                  {{-- <span class="prev-price">16.51</span> --}}
                  <span class="price">Rp{{ number_format($product->harga_produk, 0, ',', '.') }}</span>
                  {{-- <span class="saving-price">save 8%</span> --}}
                </p>
              </div>
              <p class="mb-20 pro-desc-details">Faded short sleeves t-shirt with high neckline. Soft and stretchy material for a comfortable fit.
                Accessorize with a straw hat and you're ready for summer!</p>
              {{-- <div class="product-size mb-20 clearfix">
                <label>Size</label>
                <select class="">
                  <option>S</option>
                  <option>M</option>
                  <option>L</option>
                </select>
              </div>
              <div class="color clearfix mb-20">
                <label>color</label>
                <ul class="color-list">
                  <li>
                    <a class="orange active" href="#"></a>
                  </li>
                  <li>
                    <a class="paste" href="#"></a>
                  </li>
                </ul>
              </div> --}}
              <div class="box-quantity d-flex hot-product2">
                <input name="quantity" id="quantity" class="quantity mr-15" type="number" min="1" max="{{ $product->stok_produk }}"
                  value="1">
                <div class="pro-actions">
                  <div class="actions-primary">
                    @if (Auth::check())
                      <a href="javascript:void(0)" class="add-to-cart-id" data-url="{{ route('product.add.cart', $product->id) }}" title="Add to Cart">
                        + Add To Cart
                      </a>
                    @else
                      <a href="{{ route('product.cart') }}" class="add-to-cart" title="Add to Cart">
                        + Add To Cart
                      </a>
                    @endif
                  </div>
                </div>
              </div>
              <div class="pro-ref mt-20">
                <p><span class="in-stock"><i class="ion-checkmark-round"></i>IN STOCK {{ $product->stok_produk }}</span></p>
              </div>
              <div class="socila-sharing mt-25">
                <ul class="d-flex">
                  <li>share</li>
                  <li><a href="#"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                  <li><a href="#"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>
                  <li><a href="#"><i class="fa fa-google-plus-official" aria-hidden="true"></i></a></li>
                  <li><a href="#"><i class="fa fa-pinterest-p" aria-hidden="true"></i></a></li>
                </ul>
              </div>
            </div>
          </div>
          <!-- Thumbnail Description End -->
        </div>
        <!-- Row End -->
      </div>
    </div>
    <!-- Container End -->
  </div>
  <!-- Product Thumbnail End -->
  <!-- Product Thumbnail Description Start -->
  <div class="thumnail-desc pb-100 pb-sm-60">
    <div class="container">
      <div class="row">
        <div class="col-sm-12">
          <ul class="main-thumb-desc nav tabs-area" role="tablist">
            <li><a class="active" data-toggle="tab" href="#dtail">Product Details</a></li>
            <li><a data-toggle="tab" href="#review">Reviews 1</a></li>
          </ul>
          <!-- Product Thumbnail Tab Content Start -->
          <div class="tab-content thumb-content border-default">
            <div id="dtail" class="tab-pane fade show active">
              <p>Fashion has been creating well-designed collections since 2010. The brand offers feminine designs delivering stylish separates and
                statement dresses which have since evolved into a full ready-to-wear collection in which every item is a vital part of a woman's
                wardrobe. The result? Cool, easy, chic looks with youthful elegance and unmistakable signature style. All the beautiful pieces are
                made in Italy and manufactured with the greatest attention. Now Fashion extends to a range of accessories including shoes, hats,
                belts and more!</p>
            </div>
            <div id="review" class="tab-pane fade">
              <!-- Reviews Start -->
              <div class="review border-default universal-padding">
                <div class="group-title">
                  <h2>customer review</h2>
                </div>
                <h4 class="review-mini-title">Truemart</h4>
                <ul class="review-list">
                  <!-- Single Review List Start -->
                  <li>
                    <span>Quality</span>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star-o"></i>
                    <i class="fa fa-star-o"></i>
                    <label>Truemart</label>
                  </li>
                  <!-- Single Review List End -->
                  <!-- Single Review List Start -->
                  <li>
                    <span>price</span>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star-o"></i>
                    <i class="fa fa-star-o"></i>
                    <i class="fa fa-star-o"></i>
                    <label>Review by <a href="https://themeforest.net/user/hastech">Truemart</a></label>
                  </li>
                  <!-- Single Review List End -->
                  <!-- Single Review List Start -->
                  <li>
                    <span>value</span>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star-o"></i>
                    <label>Posted on 7/20/18</label>
                  </li>
                  <!-- Single Review List End -->
                </ul>
              </div>
              <!-- Reviews End -->
              <!-- Reviews Start -->
              <div class="review border-default universal-padding mt-30">
                <h2 class="review-title mb-30">You're reviewing: <br><span>Faded Short Sleeves T-shirt</span></h2>
                <p class="review-mini-title">your rating</p>
                <ul class="review-list">
                  <!-- Single Review List Start -->
                  <li>
                    <span>Quality</span>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star-o"></i>
                    <i class="fa fa-star-o"></i>
                  </li>
                  <!-- Single Review List End -->
                  <!-- Single Review List Start -->
                  <li>
                    <span>price</span>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star-o"></i>
                    <i class="fa fa-star-o"></i>
                    <i class="fa fa-star-o"></i>
                  </li>
                  <!-- Single Review List End -->
                  <!-- Single Review List Start -->
                  <li>
                    <span>value</span>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star"></i>
                    <i class="fa fa-star-o"></i>
                  </li>
                  <!-- Single Review List End -->
                </ul>
                <!-- Reviews Field Start -->
                <div class="riview-field mt-40">
                  <form autocomplete="off" action="#">
                    <div class="form-group">
                      <label class="req" for="sure-name">Nickname</label>
                      <input type="text" class="form-control" id="sure-name" required="required">
                    </div>
                    <div class="form-group">
                      <label class="req" for="subject">Summary</label>
                      <input type="text" class="form-control" id="subject" required="required">
                    </div>
                    <div class="form-group">
                      <label class="req" for="comments">Review</label>
                      <textarea class="form-control" rows="5" id="comments" required="required"></textarea>
                    </div>
                    <button type="submit" class="customer-btn">Submit Review</button>
                  </form>
                </div>
                <!-- Reviews Field Start -->
              </div>
              <!-- Reviews End -->
            </div>
          </div>
          <!-- Product Thumbnail Tab Content End -->
        </div>
      </div>
      <!-- Row End -->
    </div>
    <!-- Container End -->
  </div>
  <!-- Product Thumbnail Description End -->
@endsection

@section('script')
  <script>
    $(document).ready(function() {
      $('.add-to-cart-id').click(function(e) {
        e.preventDefault();

        let url = $(this).data('url');
        let quantity = $('#quantity').val();

        $.ajax({
          url: url,
          method: 'POST',
          data: {
            _token: '{{ csrf_token() }}',
            quantity: quantity
          },
          success: function(response) {
            Swal.fire({
              icon: "success",
              //   title: response.message,
              text: response.message,
              timer: 4000,
            });

            // Hapus teks "Keranjang Kosong"
            $('.keranjang-kosong').remove();

            // Update jumlah barang
            if (response.cartCount !== undefined) {
              $('#cart-count').text(response.cartCount);
            }

            // 🔁 Update isi keranjang secara dinamis
            updateCart(response.cartItems, response.total);
          },
          error: function(xhr) {
            Swal.fire({
              icon: "error",
              title: "Error",
              text: xhr.responseJSON?.message || 'Terjadi kesalahan saat menambahkan item',
              timer: 4000,
            });
          }
        });
      });

      // 🧩 Fungsi update keranjang
      function updateCart(cartItems, total) {
        const wrapper = $('.cart-items-wrapper');
        const footer = $('.cart-footer');
        wrapper.empty();
        footer.empty();

        if (cartItems.length === 0) {
          wrapper.append('<p class="text-center">Keranjang kosong</p>');
          return;
        }

        cartItems.forEach(function(item) {
          const html = `
                <div class="single-cart-box" id="cart-item-${item.id}">
                <div class="cart-img">
                    <a href="${item.detail_url}">
                    <img src="${item.foto}" alt="cart-image">
                    </a>
                    <span class="pro-quantity">${item.quantity}</span>
                </div>
                <div class="cart-content">
                    <h6><a href="${item.detail_url}">${item.nama}</a></h6>
                    <span class="cart-price">Rp${item.harga}</span>
                </div>
                <a href="javascript:void(0)" class="del-icone remove-item"
                    data-id="${item.id}" data-urlcart="${item.remove_url}">
                    <i class="ion-close"></i>
                </a>
                </div>`;
          wrapper.append(html);
        });

        // Update total harga dan footer
        wrapper.append(`
            <div class="cart-footer">
                <ul class="price-content">
                <li>Total <span id="cart-total-price">Rp${total}</span></li>
                </ul>
                <div class="cart-actions text-center">
                <a class="cart-checkout" href="{{ route('product.checkout') }}">Checkout</a>
                </div>
            </div>
          `);
      }
    });
  </script>
@endsection
