<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>Laporan Penjualan</title>
    <meta content="" name="description">
    <meta content="" name="keywords">

    <!-- Favicons -->
    <link href="{{ asset('assets/img/logo.png') }}" rel="icon">
    <link href="{{ asset('assets/img/logo.png') }}" rel="logo">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
</head>

<body>

    <div>

        <h3 class="text-center my-5">
            Laporan Penjualan
            {{ \Carbon\Carbon::parse($start_date)->format('d F Y') }}
            s/d {{ \Carbon\Carbon::parse($end_date)->format('d F Y') }}
        </h3>

        <div style="margin-top: 35px; display: flex; justify-content:center; align-items:center;">
            <table class="table">
                <thead>
                    <tr>
                        <th> No </th>
                        <th>Order Date</th>
                        <th>Product</th>
                        @if (auth()->user()->role != 'Kurir')
                            <th>Price</th>
                        @endif
                        <th>Quantity</th>
                        @if (auth()->user()->role != 'Kurir')
                            <th>Subtotal</th>
                        @endif
                        <th>Order Total</th>
                        @if (auth()->user()->role != 'Kurir')
                            {{-- <th>Bukti Pembayaran</th> --}}
                            <th>Status Pembayaran</th>
                            {{-- <th>Detail Pembayaran</th> --}}
                        @endif
                        <th>Status</th>
                        <th>Customer</th>
                        @if (auth()->user()->role != 'Kurir')
                            {{-- <th>Kurir</th> --}}
                            {{-- <th>Bukti Pengiriman</th>
                            <th>Penanggung Jawab</th> --}}
                        @endif
                        @if (auth()->user()->role != 'Kurir')
                            {{-- <th>Progres</th> --}}
                        @endif
                    </tr>
                </thead>
                {{-- $no = 1; --}}
                @php
                    $no = 1;
                @endphp

                <tbody>
                    @foreach ($data as $o)
                        @foreach ($o->products as $index => $product)
                            @php
                                $isFirst = $index === 0;
                                $isLast = $index === $o->products->count() - 1;
                                $borderStyle = '';
                                if ($isFirst) {
                                    $borderStyle .= 'border-top: 3px solid #000;';
                                }
                                if ($isLast) {
                                    $borderStyle .= 'border-bottom: 3px solid #000;';
                                }
                            @endphp

                            <tr style="{{ $borderStyle }}">
                                @if ($isFirst)
                                    <td rowspan="{{ $o->products->count() }}">{{ $no++ }}</td>
                                    <td rowspan="{{ $o->products->count() }}">
                                        {{ $o->created_at->format('d M Y H:i') }}</td>
                                @endif
                                <td>{{ $product->nama_produk }}</td>
                                @if (auth()->user()->role != 'Kurir')
                                    <td>Rp {{ number_format($product->pivot->harga_produk, 0, ',', '.') }}
                                    </td>
                                @endif
                                <td>{{ $product->pivot->quantity }}</td>
                                @if (auth()->user()->role != 'Kurir')
                                    <td>Rp
                                        {{ number_format($product->pivot->harga_produk * $product->pivot->quantity, 0, ',', '.') }}
                                    </td>
                                @endif
                                @if ($isFirst)
                                    <td rowspan="{{ $o->products->count() }}">
                                        Rp
                                        {{ number_format($o->products->sum(fn($p) => $p->pivot->harga_produk * $p->pivot->quantity), 0, ',', '.') }}
                                    </td>
                                @endif
                                @if (auth()->user()->role != 'Kurir')
                                    @if ($isFirst)
                                        <td rowspan="{{ $o->products->count() }}">
                                            @if ($o->total == $o->jumlah_pelunasan)
                                                <span class="badge rounded-pill bg-success"> LUNAS </span>
                                            @else
                                                <span class="badge rounded-pill bg-secondary"> -
                                                    {{ number_format($o->sisa_pelunasan, 0, ',', '.') }}
                                                </span>
                                            @endif
                                        </td>
                                    @endif
                                @endif
                                @if ($isFirst)
                                    <td rowspan="{{ $o->products->count() }}">
                                        @if ($o->status == 'dikemas')
                                            <button type="button" class="btn btn-secondary shadow-none"
                                                data-bs-toggle="modal"
                                                data-bs-target="#status-pesanan{{ $o->id }}">
                                                <i class="bi bi-box-seam"></i>&nbsp;{{ ucfirst($o->status) }}</button>
                                        @elseif($o->status == 'dikirim')
                                            <button type="button" class="btn btn-primary shadow-none"
                                                data-bs-toggle="modal"
                                                data-bs-target="#status-pesanan{{ $o->id }}">
                                                <i class="bi bi-truck"></i>&nbsp;{{ ucfirst($o->status) }}</button>
                                        @elseif($o->status == 'selesai')
                                            <button type="button" class="btn btn-success shadow-none"
                                                data-bs-toggle="modal"
                                                data-bs-target="#status-pesanan{{ $o->id }}">
                                                <i
                                                    class="bi bi-check-circle-fill"></i>&nbsp;{{ ucfirst($o->status) }}</button>
                                        @elseif($o->status == 'dibatalkan')
                                            <button type="button" class="btn btn-danger shadow-none"
                                                data-bs-toggle="modal"
                                                data-bs-target="#status-pesanan{{ $o->id }}"><i
                                                    class="bi bi-x-circle-fill"></i>&nbsp;{{ ucfirst($o->status) }}</button>
                                        @endif
                                        @if (auth()->user()->role != 'Kurir' && auth()->user()->role != 'Owner')
                                            <div class="modal fade" id="status-pesanan{{ $o->id }}"
                                                tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog">

                                                </div>
                                            </div>
                                        @endif
                                    </td>
                                    <td rowspan="{{ $o->products->count() }}">
                                        {{ $o->customer->nama_pelanggan ?? '-' }} </ <button type="button"
                                            class="btn btn-primary shadow-none" data-bs-toggle="modal"
                                            data-bs-target="#data-cust{{ $o->customer->id }}"><i
                                            class="bi bi-person-vcard"></i></button>
                                        <div class="modal fade" id="data-cust{{ $o->customer->id }}" tabindex="-1"
                                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Informasi Customer</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                            aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <table>
                                                            <tr>
                                                                <td> Nama </td>
                                                                <td class="w-25"> : </td>
                                                                <td> {{ $o->customer->nama_pelanggan ?? '-' }}
                                                                </td>
                                                            </tr>

                                                        </table>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">Kembali</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    @if (auth()->user()->role != 'Kurir')
                                    @endif
                                    @if (auth()->user()->role != 'Kurir')
                                    @endif
                                @endif
                            </tr>
                        @endforeach
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <script type="text/javascript">
        window.print();
    </script>
</body>

</html>
