<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>Laporan Bulanan</title>
    <meta content="" name="description">
    <meta content="" name="keywords">

    <!-- Favicons -->
    <link href="{{ asset('assets/img/logo.png') }}" rel="icon">
    <link href="{{ asset('assets/img/logo.png') }}" rel="logo">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
</head>

<body>

    <div>

        <h3 class="text-center my-5">
            Laporan Pembelian
            {{ \Carbon\Carbon::parse($start_date)->format('d F Y') }}
            s/d {{ \Carbon\Carbon::parse($end_date)->format('d F Y') }}
        </h3>

        <div style="margin-top: 35px; display: flex; justify-content:center; align-items:center;">
            <table class="table">
                <thead>
                    <tr>
                        <th> No </th>
                        <th>Order Date</th>
                        <th>Jenis</th>
                        <th>Produk</th>
                        {{-- @if (auth()->user()->role != 'Kurir')
                            <th>Price</th>
                        @endif --}}
                        <th>Jumlah</th>
                        {{-- @if (auth()->user()->role != 'Kurir')
                            <th>Subtotal</th>
                        @endif --}}
                        <th>Pembayaran</th>
                        {{-- <th>Penanggung Jawab</th>
                        <th>Pesan</th> --}}
                        <th>Penjualan</th>
                        <th>Pembelian</th>

                    </tr>
                </thead>
                {{-- $no = 1; --}}
                @php
                    $no = 1;
                @endphp

                <tbody>
                    @foreach ($data as $o)
                        <tr>
                            <td>{{ $no++ }}</td>
                            <td>{{ \Carbon\Carbon::parse($o->created_at)->format('d M Y H:i') }}</td>
                            <td>
                                @if ($o->jenis == 'barang masuk')
                                    <span class="badge rounded-pill bg-success">{{ $o->jenis }}</span>
                                @elseif($o->jenis == 'barang keluar')
                                    <span class="badge rounded-pill bg-danger">{{ $o->jenis }}</span>
                                @endif
                            </td>
                            <td>{{ $o->produk->nama_produk ?? '-' }}</td>
                            {{-- @if (auth()->user()->role != 'Kurir')
                                <td>Rp {{ number_format($o->produk->harga_produk ?? 0, 0, ',', '.') }}</td>
                            @endif --}}
                            <td>{{ $o->jumlah_barang }}</td>

                            <td>
                                @if ($o->jenis == 'barang masuk')
                                    <span class="badge rounded-pill bg-danger"><i class="bi bi-dash-circle"></i></span>
                                    {{ number_format($o->pembayaran, 0, ',', '.') }}
                                @elseif($o->jenis == 'barang keluar')
                                    <span class="badge rounded-pill bg-success"><i class="bi bi-plus-circle"></i></span>
                                    {{ number_format($o->pembayaran, 0, ',', '.') }} <br>
                                    @if ($o->pelacakan)
                                        @if ($o->pelacakan->status == 'dikemas' || $o->pelacakan->status == 'dikirim')
                                            sedang {{ $o->pelacakan->status }}
                                        @elseif ($o->pelacakan->status == 'dibatalkan')
                                            {{ $o->pelacakan->status }}
                                        @else
                                            @if ($o->pelacakan->jumlah_pelunasan == null)
                                                belum dibayar
                                            @else
                                                Dibayar :
                                                {{ number_format($o->pelacakan->jumlah_pelunasan, 0, ',', '.') }}
                                                <br>
                                                @if ($o->pelacakan->sisa_pelunasan != 0)
                                                    <span class="badge rounded-pill bg-warning"><i
                                                            class="bi bi-exclamation-circle"></i></span>{{ number_format($o->pelacakan->sisa_pelunasan, 0, ',', '.') }}
                                                @else
                                                    Status : Lunas
                                                @endif
                                            @endif
                                        @endif
                                    @endif
                                @endif
                            </td>

                            {{-- <td>Pembelian</td> --}}
                            {{-- @if (isset($o->staff->name))
                                <td>{{ $o->staff->name }} ( {{ $o->staff->email }} ) </td>
                            @else
                                <td> - </td>
                            @endif --}}


                            {{-- <td class="w-25">
                                @if ($o->pesan == null)
                                    -
                                @else
                                    {{ $o->pesan }}
                                @endif
                            </td> --}}

                            <td>{{ $o->nama_pelanggan }}</td>
                            <td>{{ $o->nama_sales }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <script type="text/javascript">
        window.print();
    </script>
</body>

</html>
