@extends('layouts.main')

@section('content')
    <div class="pagetitle">
        <h1>{{ $title }}</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Home</a></li>
                <li class="breadcrumb-item active"> {{ $title }} </li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section profile">
        <div class="row">
            <div class="col-xl-12">
                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-1"></i>
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @elseif (session()->has('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-octagon me-1"></i>
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
            </div>

            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body pt-3">
                        <form action="{{ route('inventory.index') }}" method="GET" id="filterForm">
                            <div class="row text-center mb-3">
                                <div class="col-md-1 my-1">
                                    <a href="{{ route('inventory.create') }}" class="btn btn-primary"><i
                                            class="bi bi-plus"></i> </a>
                                </div>
                                <div class="col-md-5 my-1">
                                    <input type="date" name="tanggal" id="tanggal" class="form-control"
                                        onchange="document.getElementById('filterForm').submit();"
                                        value="{{ request('tanggal') }}">
                                </div>
                                <div class="col-md-5 my-1">
                                    <select onchange="document.getElementById('filterForm').submit();" name="jenis"
                                        id="jenis" class="form-control">
                                        <option value="" selected disabled>Filter Jenis Informasi</option>
                                        <option value="barang masuk">Barang Masuk</option>
                                        <option value="barang keluar">Barang Keluar</option>
                                    </select>
                                </div>

                                @if (auth()->user()->role == 'Owner')
                                    <div class="col-md-1 my-1">
                                        <a href="{{ route('inventory.laporan') }}" class="btn btn-warning"><i
                                                class="bi bi-download"></i> </a>
                                    </div>
                                @endif
                            </div>
                        </form>

                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th> No </th>
                                        <th> Tanggal </th>
                                        <th> Jenis </th>
                                        <th> Produk </th>
                                        <th> Jumlah </th>
                                        <th> Pembayaran </th>
                                        <th> Penanggung Jawab </th>
                                        <th class="w-25"> Pesan </th>
                                        <th> Penjualan </th>
                                        <th> Pembelian </th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @php $no = 1; @endphp
                                    @foreach ($data as $item)
                                        <tr>
                                            <td>{{ $no++ }}</td>
                                            <td>{{ $item->created_at->format('d M Y H:i') }}</td>
                                            <td>
                                                @if ($item->jenis == 'barang masuk')
                                                    <span class="badge rounded-pill bg-success">{{ $item->jenis }}</span>
                                                @elseif($item->jenis == 'barang keluar')
                                                    <span class="badge rounded-pill bg-danger">{{ $item->jenis }}</span>
                                                @endif
                                            </td>
                                            <td>{{ $item->produk->nama_produk }} </td>
                                            <td>{{ $item->jumlah_barang }}</td>
                                            <td>
                                                @if ($item->jenis == 'barang masuk')
                                                    <span class="badge rounded-pill bg-danger"><i
                                                            class="bi bi-dash-circle"></i></span>
                                                    {{ number_format($item->pembayaran, 0, ',', '.') }}
                                                @elseif($item->jenis == 'barang keluar')
                                                    <span class="badge rounded-pill bg-success"><i
                                                            class="bi bi-plus-circle"></i></span>
                                                    {{ number_format($item->pembayaran, 0, ',', '.') }} <br>
                                                    @if ($item->pelacakan)
                                                        @if ($item->pelacakan->status == 'dikemas' || $item->pelacakan->status == 'dikirim')
                                                            sedang {{ $item->pelacakan->status }}
                                                        @elseif ($item->pelacakan->status == 'dibatalkan')
                                                            {{ $item->pelacakan->status }}
                                                        @else
                                                            @if ($item->pelacakan->jumlah_pelunasan == null)
                                                                belum dibayar
                                                            @else
                                                                Dibayar :
                                                                {{ number_format($item->pelacakan->jumlah_pelunasan, 0, ',', '.') }}
                                                                <br>
                                                                @if ($item->pelacakan->sisa_pelunasan != 0)
                                                                    <span class="badge rounded-pill bg-warning"><i
                                                                            class="bi bi-exclamation-circle"></i></span>{{ number_format($item->pelacakan->sisa_pelunasan, 0, ',', '.') }}
                                                                @else
                                                                    Status : Lunas
                                                                @endif
                                                            @endif
                                                        @endif
                                                    @endif
                                                @endif
                                            </td>
                                            @if (isset($item->staff->name))
                                                <td>{{ $item->staff->name }} ( {{ $item->staff->email }} ) </td>
                                            @else
                                                <td> - </td>
                                            @endif


                                            <td class="w-25">
                                                @if ($item->pesan == null)
                                                    -
                                                @else
                                                    {{ $item->pesan }}
                                                @endif
                                            </td>

                                            <td>{{ $item->nama_pelanggan }}</td>
                                            <td>{{ $item->nama_sales }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </section>
@endsection
