<div class="table-responsive">
    <table class="table">
        <thead>
            <tr>
                <th> No </th>
                <th> Tanggal </th>
                <th> Jenis </th>
                <th> Produk </th>
                <th> Jumlah </th>
                <th> Pembayaran </th>
                <th> Penanggung Jawab </th>
                <th class="w-25"> Pesan </th>
                <th> Penjualan </th>
                <th> Pembelian </th>

            </tr>
        </thead>
        <tbody>
            @php $no = 1; @endphp
            @foreach ($data as $item)
                <tr>
                    <td>{{ $no++ }}</td>
                    <td>{{ $item->created_at->format('d M Y H:i') }}</td>
                    <td>
                        @if ($item->jenis == 'barang masuk')
                            <span class="badge rounded-pill bg-success">{{ $item->jenis }}</span>
                        @elseif($item->jenis == 'barang keluar')
                            <span class="badge rounded-pill bg-danger">{{ $item->jenis }}</span>
                        @endif
                    </td>
                    <td>{{ $item->produk->nama_produk }} </td>
                    <td>{{ $item->jumlah_barang }}</td>
                    <td>
                        @if ($item->jenis == 'barang masuk')
                            <span class="badge rounded-pill bg-danger"><i class="bi bi-dash-circle"></i></span>
                            {{ number_format($item->pembayaran, 0, ',', '.') }}
                        @elseif($item->jenis == 'barang keluar')
                            <span class="badge rounded-pill bg-success"><i class="bi bi-plus-circle"></i></span>
                            {{ number_format($item->pembayaran, 0, ',', '.') }} <br>
                            @if ($item->pelacakan)
                                @if ($item->pelacakan->status == 'dikemas' || $item->pelacakan->status == 'dikirim')
                                    sedang {{ $item->pelacakan->status }}
                                @elseif ($item->pelacakan->status == 'dibatalkan')
                                    {{ $item->pelacakan->status }}
                                @else
                                    @if ($item->pelacakan->jumlah_pelunasan == null)
                                        belum dibayar
                                    @else
                                        Dibayar :
                                        {{ number_format($item->pelacakan->jumlah_pelunasan, 0, ',', '.') }}
                                        <br>
                                        @if ($item->pelacakan->sisa_pelunasan != 0)
                                            <span class="badge rounded-pill bg-warning"><i
                                                    class="bi bi-exclamation-circle"></i></span>{{ number_format($item->pelacakan->sisa_pelunasan, 0, ',', '.') }}
                                        @else
                                            Status : Lunas
                                        @endif
                                    @endif
                                @endif
                            @endif
                        @endif
                    </td>
                    @if (isset($item->staff->name))
                        <td>{{ $item->staff->name }} ( {{ $item->staff->email }} ) </td>
                    @else
                        <td> - </td>
                    @endif


                    <td class="w-25">
                        @if ($item->pesan == null)
                            -
                        @else
                            {{ $item->pesan }}
                        @endif
                    </td>

                    <td>{{ $item->nama_pelanggan }}</td>
                    <td>{{ $item->nama_sales }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
