@extends('layouts.main')

@section('content')
    <div class="pagetitle">
        <h1>{{ $title }}</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Home</a></li>
                <li class="breadcrumb-item active"> {{ $title }} </li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section profile">
        <div class="row">
            <div class="col-xl-12">
                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-1"></i>
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @elseif (session()->has('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-octagon me-1"></i>
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
            </div>

            <div class="col-xl-12">
                <div class="card">
                    <div class="border p-4 rounded">
                        <div class="row justify-content-center">
                            <div class="col-lg-3">
                                <div class="box py-4 px-3 rounded border">
                                    <a href="{{ url('/admin/laporan_toko/penjualan_all') }}"
                                        class="nav-link {{ Request::is('laporan_toko*') ? '' : 'collapsed' }}">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <h5 class="mb-0">Penjualan</h5>
                                            <div>
                                                {{-- <a href="penjualan.html" class="btn btn-info"><i class="fa fa-eye"></i></a> --}}


                                                {{-- eye icon --}}
                                                <i class="bi bi-eye-fill"></i>

                                                {{-- <span>Laporan Toko</span> --}}

                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="box py-4 px-3 rounded border">
                                    <a href="{{ url('/admin/laporan_toko/pembelian_all') }}"
                                        class="nav-link {{ Request::is('laporan_toko*') ? '' : 'collapsed' }}">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <h5 class="mb-0">Pembelian</h5>
                                            <div>
                                                <i class="bi bi-eye-fill"></i>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="box py-4 px-3 rounded border">
                                    <a href="{{ url('/admin/laporan_toko/penjualan_per_status') }}"
                                        class="nav-link {{ Request::is('laporan_toko*') ? '' : 'collapsed' }}">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <h5 class="mb-0">Status</h5>
                                            <div>
                                                <i class="bi bi-eye-fill"></i>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="box py-4 px-3 rounded border">
                                    <a href="{{ url('/admin/laporan_toko/penjualan_per_cara_bayar') }}"
                                        class="nav-link {{ Request::is('laporan_toko*') ? '' : 'collapsed' }}">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <h5 class="mb-0">Pelunasan</h5>
                                            <div>
                                                <i class="bi bi-eye-fill"></i>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <div class="w-100 my-2"></div>
                            <div class="col-lg-3">
                                <div class="box py-4 px-3 rounded border">
                                    <a href="{{ url('/admin/laporan_toko/penjualan_per_produk') }}"
                                        class="nav-link {{ Request::is('laporan_toko*') ? '' : 'collapsed' }}">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <h5 class="mb-0">Produk Toko</h5>
                                            <div>
                                                <i class="bi bi-eye-fill"></i>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

    </section>
@endsection
