@extends('layouts.main')

@section('content')
    <div class="pagetitle">
        <h1>{{ $title }}</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Home</a></li>
                <li class="breadcrumb-item active"> {{ $title }} </li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section profile">
        <div class="row">
            <div class="col-xl-12">
                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-1"></i>
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @elseif (session()->has('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-octagon me-1"></i>
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
            </div>

            <div class="col-xl-12">
                <div class="card">

                    <div class="border p-4 rounded">
                        <center>
                            <a href="{{ url('/admin/laporan_toko/') }}" class="btn btn-danger"><i
                                    class="fa fa-arrow-circle-left"></i> Kembali</a>

                            <br><br>
                        </center>
                        <div class="row justify-content-center">
                            @foreach ($bulanUnik as $item)
                                <div class="col-lg-3 mb-3">
                                    <div class="box py-4 px-3 rounded border text-center">
                                        <form method="GET" action="{{ route('pembelian_per_bulan') }}">
                                            <input type="hidden" name="tahun" value="{{ $item->tahun }}">
                                            <input type="hidden" name="bulan" value="{{ $item->bulan }}">
                                            @php
                                                $isSelected =
                                                    request('bulan') == $item->bulan &&
                                                    request('tahun') == $item->tahun;
                                            @endphp

                                            <button type="submit"
                                                class="btn w-100 {{ $isSelected ? 'btn-warning text-dark fw-bold' : 'btn-outline-primary' }}">
                                                {{ $item->nama_bulan }} {{ $item->tahun }}
                                            </button>

                                        </form>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        {{-- <div class="text-end mb-3">
                            <a href="{{ route('inventory.unduh.laporan_pembelian', ['tahun' => $selectedTahun, 'bulan' => $selectedBulan]) }}"
                                class="btn btn-info" target="_blank"> Unduh
                                <i class="bi bi-download"></i>
                            </a>
                        </div> --}}
                        @if ($selectedTahun && $selectedBulan)
                            <div class="text-end mb-3">
                                <a href="{{ route('inventory.unduh.laporan_pembelian', ['tahun' => $selectedTahun, 'bulan' => $selectedBulan]) }}"
                                    class="btn btn-info" target="_blank"> Unduh
                                    <i class="bi bi-download"></i>
                                </a>
                            </div>
                        @endif
                        @if ($selectedTahun && $selectedBulan)
                            <hr>
                            <h4 class="mt-4">Data Transaksi:
                                {{ \Carbon\Carbon::create()->month($selectedBulan)->translatedFormat('F') }}
                                {{ $selectedTahun }}</h4>
                            {{-- return view('pages.inventory.index', compact('no', 'title', 'data')); --}}
                            @include('pages.inventory.partial_table', [
                                'data' => $data,
                                'selectedTahun' => $selectedTahun,
                                'selectedBulan' => $selectedBulan,
                            ])
                        @endif

                    </div>
                </div>

            </div>

    </section>
@endsection
