{{-- filepath: resources/views/pages/laporan_toko/penjualan_per_produk.blade.php --}}
@extends('layouts.main')

@section('content')
    <div class="pagetitle">
        <h1>{{ $title }}</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Home</a></li>
                <li class="breadcrumb-item active">{{ $title }}</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section profile">
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="border p-4 rounded">
                        <center>
                            <a href="{{ url('/admin/laporan_toko/') }}" class="btn btn-danger"><i
                                    class="fa fa-arrow-circle-left"></i> Kembali</a>
                            <br><br>
                        </center>

                        <h4 class="mb-3">Pilih Produk Terlaris</h4>
                        <div class="row justify-content-center">
                            @foreach ($produkTerlaris as $item)
                                @php
                                    $isSelected = request('id_produk') == $item->id;
                                @endphp
                                <div class="col-lg-3 mb-3">
                                    <form method="GET" action="{{ route('penjualan_per_produk') }}">
                                        <input type="hidden" name="id_produk" value="{{ $item->id }}">
                                        <button type="submit"
                                            class="btn w-100 {{ $isSelected ? 'btn-warning text-dark fw-bold' : 'btn-outline-secondary' }}">
                                            {{ $item->nama_produk }}
                                        </button>
                                    </form>
                                </div>
                            @endforeach
                        </div>

                        @if ($selectedProdukId)

                            <div class="text-end mb-3">
                                <form id="filterForm" method="GET" action="{{ route('penjualan_per_produk') }}"
                                    class="row justify-content-end">
                                    <input type="hidden" name="id_produk" value="{{ $selectedProdukId }}">

                                    <div class="row justify-content-center">
                                        <div class="col-md-4 my-1">
                                            <input type="date" name="start_date" id="start_date"
                                                class="form-control form-control-md" onchange="this.form.submit();"
                                                value="{{ request('start_date') }}">
                                        </div>

                                        <div class="col-md-4 my-1">
                                            <input type="date" name="end_date" id="end_date"
                                                class="form-control form-control-md" onchange="this.form.submit();"
                                                value="{{ request('end_date') }}">
                                        </div>
                                    </div>
                                </form>

                                @if ($start_date && $end_date)
                                    <div class="text-end mb-3">
                                        <a href="{{ route('inventory.unduh.laporan_produk', ['produk' => $selectedProdukId, 'start_date' => $start_date, 'end_date' => $end_date]) }}"
                                            class="btn btn-info" target="_blank"> Unduh
                                            <i class="bi bi-download"></i>
                                        </a>
                                    </div>
                                @endif
                            </div>
                            <hr>
                            <h4 class="mt-4">Data Transaksi untuk Produk:
                                <strong>
                                    {{ optional($produkTerlaris->firstWhere('id', $selectedProdukId))->nama_produk }}
                                </strong>
                            </h4>
                            @if ($orders->count())
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Tanggal Order</th>
                                                <th>Customer</th>
                                                <th>Status</th>
                                                <th>Daftar Produk</th>
                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($orders as $i => $order)
                                                <tr>
                                                    <td>{{ $i + 1 }}</td>
                                                    <td>{{ $order->created_at->format('d-m-Y H:i') }}</td>
                                                    <td>{{ $order->customer->nama_pelanggan ?? '-' }}</td>
                                                    <td>{{ ucfirst($order->status) }}</td>
                                                    <td>
                                                        @foreach ($order->products as $prod)
                                                            <div>
                                                                {{ $prod->nama_produk }} ({{ $prod->pivot->quantity }})
                                                            </div>
                                                        @endforeach
                                                    </td>
                                                    <td>Rp {{ number_format($order->total, 0, ',', '.') }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="alert alert-info mt-3">Tidak ada transaksi untuk produk ini.</div>
                            @endif
                        @endif

                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
