@extends('layouts.main')

@section('content')
    <div class="pagetitle">
        <h1>{{ $title }}</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Home</a></li>
                <li class="breadcrumb-item active"> {{ $title }} </li>
            </ol>
        </nav>
    </div><!-- End Page Title -->

    <section class="section profile">
        <div class="row">
            <div class="col-xl-12">
                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-1"></i>
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @elseif (session()->has('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-octagon me-1"></i>
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
            </div>

            <div class="col-xl-12">
                <div class="card">

                    <div class="border p-4 rounded">
                        <center>
                            <a href="{{ url('/admin/laporan_toko/') }}" class="btn btn-danger"><i
                                    class="fa fa-arrow-circle-left"></i> Kembali</a>

                            <br><br>
                        </center>
                        <div class="row justify-content-center">
                            @foreach ($statusUnik as $status)
                                @php
                                    $isSelected = request('status') === $status;
                                @endphp
                                <div class="col-lg-3 mb-3">
                                    <form method="GET" action="{{ route('penjualan_per_status') }}">
                                        <input type="hidden" name="status" value="{{ $status }}">
                                        <button type="submit"
                                            class="btn w-100 {{ $isSelected ? 'btn-warning text-dark fw-bold' : 'btn-outline-secondary' }}">
                                            {{ ucfirst($status) }}
                                        </button>
                                    </form>
                                </div>
                            @endforeach
                        </div>
                        @if ($selectedStatus)
                            <div class="text-end mb-3">
                                <form id="filterForm" method="GET" action="{{ route('penjualan_per_status') }}"
                                    class="row justify-content-end">
                                    <input type="hidden" name="status" value="{{ $selectedStatus }}">

                                    <div class="row justify-content-center">
                                        <div class="col-md-4 my-1">
                                            <input type="date" name="start_date" id="start_date"
                                                class="form-control form-control-md" onchange="this.form.submit();"
                                                value="{{ request('start_date') }}">
                                        </div>

                                        <div class="col-md-4 my-1">
                                            <input type="date" name="end_date" id="end_date"
                                                class="form-control form-control-md" onchange="this.form.submit();"
                                                value="{{ request('end_date') }}">
                                        </div>
                                    </div>
                                </form>
                                @if ($start_date && $end_date)
                                    <div class="text-end mb-3">
                                        <a href="{{ route('inventory.unduh.laporan_status', ['start_date' => $start_date, 'end_date' => $end_date, 'status' => $selectedStatus]) }}"
                                            class="btn btn-info" target="_blank"> Unduh
                                            <i class="bi bi-download"></i>
                                        </a>
                                    </div>
                                @endif
                            </div>
                            <hr>
                            <h4 class="mt-4">Data Transaksi dengan Status:
                                <strong>{{ ucfirst($selectedStatus) }}</strong>
                            </h4>
                            @include('pages.pelacakan.partial_table', [
                                'orders' => $orders,
                                'kurir' => $kurir,
                                'no' => $no,
                            ])
                        @endif

                    </div>
                </div>

            </div>

    </section>
@endsection
