<div class="table-responsive">
    <table class="table">
        <thead>
            <tr>
                <th> No </th>
                <th>Order Date</th>
                <th>Product</th>
                @if (auth()->user()->role != 'Kurir')
                    <th>Price</th>
                @endif
                <th>Quantity</th>
                @if (auth()->user()->role != 'Kurir')
                    <th>Subtotal</th>
                @endif
                <th>Order Total</th>
                @if (auth()->user()->role != 'Kurir')
                    <th>Bukti Pembayaran</th>
                    <th>Status Pembayaran</th>
                    <th>Detail Pembayaran</th>
                @endif
                <th>Status</th>
                <th>Detail Cust</th>
                @if (auth()->user()->role != 'Kurir')
                    {{-- <th>Kurir</th> --}}
                    <th>Bukti Pengiriman</th>
                    <th>Penanggung Jawab</th>
                @endif
                @if (auth()->user()->role != 'Kurir')
                    <th>Progres</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @foreach ($orders as $o)
                @foreach ($o->products as $index => $product)
                    @php
                        $isFirst = $index === 0;
                        $isLast = $index === $o->products->count() - 1;
                        $borderStyle = '';
                        if ($isFirst) {
                            $borderStyle .= 'border-top: 3px solid #000;';
                        }
                        if ($isLast) {
                            $borderStyle .= 'border-bottom: 3px solid #000;';
                        }
                    @endphp

                    <tr style="{{ $borderStyle }}">
                        @if ($isFirst)
                            <td rowspan="{{ $o->products->count() }}">{{ $no++ }}</td>
                            <td rowspan="{{ $o->products->count() }}">
                                {{ $o->created_at->format('d M Y H:i') }}</td>
                        @endif
                        <td>{{ $product->nama_produk }}</td>
                        @if (auth()->user()->role != 'Kurir')
                            <td>Rp {{ number_format($product->pivot->harga_produk, 0, ',', '.') }}
                            </td>
                        @endif
                        <td>{{ $product->pivot->quantity }}</td>
                        @if (auth()->user()->role != 'Kurir')
                            <td>Rp
                                {{ number_format($product->pivot->harga_produk * $product->pivot->quantity, 0, ',', '.') }}
                            </td>
                        @endif
                        @if ($isFirst)
                            <td rowspan="{{ $o->products->count() }}">
                                Rp
                                {{ number_format($o->products->sum(fn($p) => $p->pivot->harga_produk * $p->pivot->quantity), 0, ',', '.') }}
                            </td>
                        @endif
                        @if (auth()->user()->role != 'Kurir')
                            @if ($isFirst)
                                <td rowspan="{{ $o->products->count() }}">
                                    @if ($o->bukti && file_exists(storage_path('app/public/bukti_pembayaran/' . $o->bukti)))
                                        {{-- Thumbnail Gambar --}}
                                        <img src="{{ asset('storage/bukti_pembayaran/' . $o->bukti) }}" width="50"
                                            alt="{{ $o->bukti }}" class="img-thumbnail" style="cursor: pointer;"
                                            data-bs-toggle="modal" data-bs-target="#imgModal{{ $o->id }}">
                                        {{-- Modal untuk gambar --}}
                                        <div class="modal fade" id="imgModal{{ $o->id }}" tabindex="-1"
                                            aria-labelledby="imageModalLabel{{ $o->id }}" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered modal-md">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title"
                                                            id="imageModalLabel{{ $o->id }}">
                                                            Bukti Pembayaran</h5>
                                                        <button type="button" class="btn-close"
                                                            style="transform: scale(1.5);" data-bs-dismiss="modal"
                                                            aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body text-center">
                                                        <img src="{{ asset('storage/bukti_pembayaran/' . $o->bukti) }}"
                                                            class="img-fluid" alt="Bukti Pembayaran">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @else
                                        <span class="text-muted fw-bold">Cash</span>
                                    @endif
                                </td>
                                <td rowspan="{{ $o->products->count() }}">
                                    @if ($o->total == $o->jumlah_pelunasan)
                                        <span class="badge rounded-pill bg-success"> LUNAS </span>
                                    @else
                                        <span class="badge rounded-pill bg-secondary"> -
                                            {{ number_format($o->sisa_pelunasan, 0, ',', '.') }}
                                        </span>
                                    @endif
                                </td>
                                <td rowspan="{{ $o->products->count() }}">
                                    <button type="button" class="btn btn-primary shadow-none" data-bs-toggle="modal"
                                        data-bs-target="#data-pembayaran{{ $o->id }}"><i
                                            class="bi bi-receipt"></i></button>
                                    <div class="modal fade" id="data-pembayaran{{ $o->id }}" tabindex="-1"
                                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Informasi Pembayaran
                                                    </h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <table class="table table-bordered">
                                                        <tr>
                                                            <td class="text-start fw-bold">Total
                                                                Order</td>
                                                            <td class="text-center">
                                                                {{ $o->total !== null ? 'Rp ' . number_format($o->total, 0, ',', '.') : '-' }}
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="text-start fw-bold">Jumlah
                                                                Telah Dibayar</td>
                                                            <td class="text-center">
                                                                {{ $o->jumlah_pelunasan !== null ? 'Rp ' . number_format($o->jumlah_pelunasan, 0, ',', '.') : '-' }}
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="text-start fw-bold">Sisa
                                                                Cicilan</td>
                                                            <td class="text-center">
                                                                {!! $o->sisa_pelunasan == 0 || $o->sisa_pelunasan === null
                                                                    ? '<span class="badge bg-success fs-6">Lunas</span>'
                                                                    : 'Rp ' . number_format($o->sisa_pelunasan, 0, ',', '.') !!}
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Kembali</button>
                                                    <button type="button" class="btn btn-primary shadow-none"
                                                        data-bs-toggle="modal"
                                                        data-bs-target="#bayar{{ $o->id }}">Ubah</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal fade" id="bayar{{ $o->id }}" tabindex="-1"
                                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <form action="{{ route('pelacakan.update', $o->id) }}" method="post">
                                                @csrf
                                                @method('put')
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Pelunasan Barang
                                                        </h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                            aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body row">
                                                        <div class="col-md-12 mb-3">
                                                            <label for="total" class="form-label">Total</label>
                                                            <input type="number"
                                                                class="form-control @error('total') is-invalid @enderror shadow-none"
                                                                id="total" value="{{ $o->total }}" readonly>
                                                            @error('total')
                                                                <div class="invalid-feedback">
                                                                    {{ $message }}
                                                                </div>
                                                            @enderror
                                                        </div>
                                                        <div class="col-md-12 mb-3">
                                                            <label for="sudah_dibayar" class="form-label">Sudah
                                                                Dibayar</label>
                                                            <input type="number"
                                                                class="form-control @error('sudah_dibayar') is-invalid @enderror shadow-none"
                                                                id="sudah_dibayar" value="{{ $o->jumlah_pelunasan }}"
                                                                readonly>
                                                            @error('sudah_dibayar')
                                                                <div class="invalid-feedback">
                                                                    {{ $message }}
                                                                </div>
                                                            @enderror
                                                        </div>
                                                        <div class="col-md-12">
                                                            <label for="sisa_cicilan" class="form-label">Sisa
                                                                Cicilan</label>
                                                            <input type="number"
                                                                class="form-control @error('sisa_cicilan') is-invalid @enderror shadow-none"
                                                                id="sisa_cicilan" value="{{ $o->sisa_pelunasan }}"
                                                                readonly>
                                                            @error('sisa_cicilan')
                                                                <div class="invalid-feedback">
                                                                    {{ $message }}
                                                                </div>
                                                            @enderror
                                                        </div>
                                                        <div class="col-md-6 mt-3">
                                                            <label for="pembayaran" class="form-label">Jumlah
                                                                Pembayaran</label>
                                                            <input type="number" max="{{ $o->total }}"
                                                                name="pembayaran"
                                                                class="form-control @error('pembayaran') is-invalid @enderror shadow-none"
                                                                id="pembayaran" value="{{ old('pembayaran') }}">
                                                            @error('pembayaran')
                                                                <div class="invalid-feedback">
                                                                    {{ $message }}
                                                                </div>
                                                            @enderror
                                                        </div>
                                                        <div class="col-md-6 mt-3">
                                                            <label for="sisa" class="form-label">Sisa
                                                                Pembayaran</label>
                                                            <input type="number" name="sisa"
                                                                class="form-control @error('sisa') is-invalid @enderror shadow-none"
                                                                id="sisa" value="{{ old('sisa') }}" readonly>
                                                            @error('sisa')
                                                                <div class="invalid-feedback">
                                                                    {{ $message }}
                                                                </div>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div
                                                        class="modal-footer d-flex justify-content-between align-items-center">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">Kembali</button>
                                                        <button type="submit" class="btn btn-primary">Kirim</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            @endif
                        @endif
                        @if ($isFirst)
                            <td rowspan="{{ $o->products->count() }}">
                                @if ($o->status == 'dikemas')
                                    <button type="button" class="btn btn-secondary shadow-none"
                                        data-bs-toggle="modal" data-bs-target="#status-pesanan{{ $o->id }}">
                                        <i class="bi bi-box-seam"></i>&nbsp;{{ ucfirst($o->status) }}</button>
                                @elseif($o->status == 'dikirim')
                                    <button type="button" class="btn btn-primary shadow-none" data-bs-toggle="modal"
                                        data-bs-target="#status-pesanan{{ $o->id }}">
                                        <i class="bi bi-truck"></i>&nbsp;{{ ucfirst($o->status) }}</button>
                                @elseif($o->status == 'selesai')
                                    <button type="button" class="btn btn-success shadow-none" data-bs-toggle="modal"
                                        data-bs-target="#status-pesanan{{ $o->id }}">
                                        <i
                                            class="bi bi-check-circle-fill"></i>&nbsp;{{ ucfirst($o->status) }}</button>
                                @elseif($o->status == 'dibatalkan')
                                    <button type="button" class="btn btn-danger shadow-none" data-bs-toggle="modal"
                                        data-bs-target="#status-pesanan{{ $o->id }}"><i
                                            class="bi bi-x-circle-fill"></i>&nbsp;{{ ucfirst($o->status) }}</button>
                                @endif
                                @if (auth()->user()->role != 'Kurir' && auth()->user()->role != 'Owner')
                                    <div class="modal fade" id="status-pesanan{{ $o->id }}" tabindex="-1"
                                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <form action="{{ route('pelacakan.update.status', $o->id) }}"
                                                    method="POST">
                                                    @csrf
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Ubah Status Pesanan
                                                        </h5>
                                                        <button type="button" class="btn-close"
                                                            data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <label for="status" class="form-label">Ubah Status</label>
                                                        <select name="status" id="status"
                                                            class="form-select @error('status') is-invalid @enderror">
                                                            <option disabled selected>Pilih Status
                                                            </option>
                                                            <option value="dikemas"
                                                                {{ $o->status == 'dikemas' ? 'selected' : '' }}>
                                                                Dikemas</option>
                                                            <option value="dikirim"
                                                                {{ $o->status == 'dikirim' ? 'selected' : '' }}>
                                                                Dikirim</option>
                                                            <option value="selesai"
                                                                {{ $o->status == 'selesai' ? 'selected' : '' }}>
                                                                Selesai</option>
                                                            <option value="dibatalkan"
                                                                {{ $o->status == 'dibatalkan' ? 'selected' : '' }}>
                                                                Dibatalkan</option>
                                                        </select>
                                                        @error('status')
                                                            <div class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">Kembali</button>
                                                        <button type="submit"
                                                            class="btn btn-primary text-white shadow-none">Simpan</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </td>
                            <td rowspan="{{ $o->products->count() }}">
                                <button type="button" class="btn btn-primary shadow-none" data-bs-toggle="modal"
                                    data-bs-target="#data-cust{{ $o->customer->id }}"><i
                                        class="bi bi-person-vcard"></i></button>
                                <div class="modal fade" id="data-cust{{ $o->customer->id }}" tabindex="-1"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Informasi Customer</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <table>
                                                    <tr>
                                                        <td> Nama </td>
                                                        <td class="w-25"> : </td>
                                                        <td> {{ $o->customer->nama_pelanggan ?? '-' }}
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td> No. HP </td>
                                                        <td class="w-25"> : </td>
                                                        <td>
                                                            {{ $o->customer->phone ?? '-' }}
                                                            @if (!empty($o->customer->phone))
                                                                @php
                                                                    $noHp = preg_replace(
                                                                        '/[^0-9]/',
                                                                        '',
                                                                        $o->customer->phone,
                                                                    ); // hapus karakter non-digit
                                                                    if (strpos($noHp, '0') === 0) {
                                                                        $noHp = '62' . substr($noHp, 1); // ganti 0 jadi 62
                                                                    }
                                                                    $whatsappLink = 'https://wa.me/' . $noHp;
                                                                @endphp
                                                                <a href="{{ $whatsappLink }}" target="_blank"
                                                                    class="btn btn-success btn-sm ms-2">
                                                                    <i class="bi bi-whatsapp"></i>
                                                                </a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td> Alamat </td>
                                                        <td class="w-25"> : </td>
                                                        <td> {{ $o->customer->alamat_pelanggan ?? '-' }}
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">Kembali</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            @if (auth()->user()->role != 'Kurir')
                                {{-- <td rowspan="{{ $o->products->count() }}">
                                                            @if ($o->id_kurir)
                                                                <button type="button" class="btn btn-primary shadow-none"
                                                                    data-bs-toggle="modal"
                                                                    data-bs-target="#data-kurir{{ $o->id }}"><i
                                                                        class="bi bi-truck"></i></button>
                                                            @else
                                                                <button type="button" class="btn btn-primary shadow-none"
                                                                    data-bs-toggle="modal"
                                                                    data-bs-target="#pilih-kurir{{ $o->id }}"><i
                                                                        class="bi bi-truck"></i></button>
                                                            @endif
                                                            <div class="modal fade" id="data-kurir{{ $o->id }}"
                                                                tabindex="-1" aria-labelledby="exampleModalLabel"
                                                                aria-hidden="true">
                                                                <div class="modal-dialog">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h5 class="modal-title">Informasi Kurir</h5>
                                                                            <button type="button" class="btn-close"
                                                                                data-bs-dismiss="modal"
                                                                                aria-label="Close"></button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            <table>
                                                                                <tr>
                                                                                    <td>Nama</td>
                                                                                    <td class="w-25"> : </td>
                                                                                    <td>{{ $o->kurir->name ?? '-' }}</td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>Email</td>
                                                                                    <td class="w-25"> : </td>
                                                                                    <td>{{ $o->kurir->email ?? '-' }}</td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button"
                                                                                class="btn btn-secondary"
                                                                                data-bs-dismiss="modal">Kembali</button>
                                                                            <button type="button"
                                                                                class="btn btn-primary text-white shadow-none"
                                                                                data-bs-toggle="modal"
                                                                                data-bs-target="#pilih-kurir{{ $o->id }}">Ganti
                                                                                Kurir</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal fade" id="pilih-kurir{{ $o->id }}"
                                                                tabindex="-1" aria-labelledby="exampleModalLabel"
                                                                aria-hidden="true">
                                                                <div class="modal-dialog">
                                                                    <div class="modal-content">
                                                                        <form
                                                                            action="{{ route('pelacakan.update.kurir', $o->id) }}"
                                                                            method="POST">
                                                                            @csrf
                                                                            @method('PUT')
                                                                            <div class="modal-header">
                                                                                <h5 class="modal-title">Pilih Kurir Untuk
                                                                                    Pengiriman</h5>
                                                                                <button type="button" class="btn-close"
                                                                                    data-bs-dismiss="modal"
                                                                                    aria-label="Close"></button>
                                                                            </div>
                                                                            <div class="modal-body">
                                                                                <label for="kurir"
                                                                                    class="form-label">Pilih Kurir</label>
                                                                                <select name="kurir" id="kurir"
                                                                                    class="form-select @error('kurir') is-invalid @enderror">
                                                                                    <option disabled selected>Pilih Kurir
                                                                                    </option>
                                                                                    @foreach ($kurir as $k)
                                                                                        <option
                                                                                            value="{{ $k->id }}">
                                                                                            {{ $k->name }}</option>
                                                                                    @endforeach
                                                                                </select>
                                                                                @error('kurir')
                                                                                    <div class="invalid-feedback">
                                                                                        {{ $message }}
                                                                                    </div>
                                                                                @enderror
                                                                            </div>
                                                                            <div class="modal-footer">
                                                                                <button type="button"
                                                                                    class="btn btn-secondary"
                                                                                    data-bs-dismiss="modal">Kembali</button>
                                                                                <button type="submit"
                                                                                    class="btn btn-primary text-white shadow-none">Simpan</button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td> --}}
                                <td rowspan="{{ $o->products->count() }}">
                                    @if ($o->bukti_pengiriman)
                                        <button type="button" class="btn btn-outline-success shadow-none"
                                            data-bs-toggle="modal" data-bs-target="#bukti{{ $o->id }}"><i
                                                class="bi bi-check-circle-fill"></i></button>
                                        <div class="modal fade" id="bukti{{ $o->id }}" tabindex="-1"
                                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Bukti Pengiriman
                                                        </h5>
                                                        <button type="button" class="btn-close"
                                                            data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <img src="{{ asset('storage/bukti_pengiriman/' . $o->bukti_pengiriman) }}"
                                                            class="img-fluid" alt="Bukti Pengiriman">
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">Kembali</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @else
                                        <p>-</p>
                                    @endif
                                </td>
                                <td rowspan="{{ $o->products->count() }}">
                                    {{ $o->staff->name ?? '-' }}
                                </td>
                            @endif
                            @if (auth()->user()->role != 'Kurir')
                                <td>
                                    @if ($o->status == 'dikirim')
                                        {{-- barang ditolak --}}

                                        {{-- barang diterima --}}
                                    @elseif($o->status == 'selesai')
                                        <button type="button" class="btn btn-outline-success shadow-none"
                                            data-bs-toggle="modal" data-bs-target="#bukti{{ $o->id }}"><i
                                                class="bi bi-check-circle-fill"></i></button>
                                        <div class="modal fade" id="bukti{{ $o->id }}" tabindex="-1"
                                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Bukti Pengiriman
                                                        </h5>
                                                        <button type="button" class="btn-close"
                                                            data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <img src="{{ asset('storage/bukti_pengiriman/' . $o->bukti_pengiriman) }}"
                                                            class="img-fluid" alt="Bukti Pengiriman">
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">Kembali</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @elseif($o->status == 'dibatalkan')
                                        <span class="badge rounded-pill bg-danger">{{ $o->status }}</span>
                                    @endif
                                </td>
                            @endif
                        @endif
                    </tr>
                @endforeach
            @endforeach
        </tbody>
    </table>
</div>
