<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Laporan Pelacakan</title>
  <link href="{{ asset('assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
  <style>
    @media print {
      .no-print {
        display: none !important;
      }

      table,
      th,
      td {
        border: 1px solid black !important;
        border-collapse: collapse !important;
      }

      th,
      td {
        padding: 6px !important;
      }
    }
  </style>
</head>

<body>

  <div class="container my-4">

    <!-- Judul Laporan -->
    <h4 class="text-center fw-bold mb-2">Laporan Pelacakan</h4>
    <p class="text-center mb-4">
      Periode: {{ \Carbon\Carbon::parse($from)->format('d-m-Y') }} s/d {{ \Carbon\Carbon::parse($to)->format('d-m-Y') }}
    </p>

    <!-- Tabel -->
    <table class="table table-bordered table-sm table-striped">
      <thead>
        <tr>
          <th>Tanggal</th>
          <th>Customer</th>
          <th>Produk</th>
          <th>Jumlah</th>
          <th>Total</th>
          <th>Status</th>
        </tr>
      </thead>
      <tbody>
        @forelse ($pelacakans as $p)
          <tr>
            <td>{{ $p->created_at->format('d-m-Y') }}</td>
            <td>{{ $p->customer->nama_pelanggan }}</td>
            <td>
              <ul class="mb-0 ps-3">
                @foreach ($p->products as $prod)
                  <li>{{ $prod->nama_produk }} (x{{ $prod->pivot->quantity }})</li>
                @endforeach
              </ul>
            </td>
            <td>{{ $p->products->sum('pivot.quantity') }}</td>
            <td>Rp{{ number_format($p->total, 0, ',', '.') }}</td>
            <td>{{ ucfirst($p->status) }}</td>
          </tr>
        @empty
          <tr>
            <td colspan="6" class="text-center">Tidak ada data pada periode ini.</td>
          </tr>
        @endforelse
      </tbody>
    </table>
  </div>

  <script>
    window.print();
  </script>

</body>

</html>
