@extends('layouts.homepage.main')

@section('content')
  <!-- Breadcrumb Start -->
  <div class="breadcrumb-area mt-30">
    <div class="container">
      <div class="breadcrumb">
        <ul class="d-flex align-items-center">
          <li><a href="/">Home</a></li>
          <li class="active"><a href="/register">Register</a></li>
        </ul>
      </div>
    </div>
    <!-- Container End -->
  </div>
  <!-- Breadcrumb End -->
  <!-- Register Account Start -->
  <div class="register-account ptb-100 ptb-sm-60">
    <div class="container">
      <div class="row">
        <div class="col-sm-12">
          <div class="register-title">
            <h3 class="mb-10">REGISTER ACCOUNT</h3>
            <p class="mb-10">If you already have an account with us, please login at the login page.</p>
          </div>
        </div>
      </div>
      <!-- Row End -->
      <div class="row">
        <div class="col-sm-12">
          <form class="form-register" action="/register" method="POST">
            @csrf
            <fieldset>
              <legend>Your Personal Details</legend>
              <div class="form-group d-md-flex align-items-md-center">
                <label class="control-label col-md-2" for="name"><span class="require">*</span>Full Name</label>
                <div class="col-md-10">
                  <input type="text" class="form-control @error('name') is-invalid @enderror" name="name"
                    value="{{ old('name') }}" id="name" placeholder="Full Name">
                  @error('name')
                    <span class="invalid-feedback" role="alert">
                      <strong>{{ $message }}</strong>
                    </span>
                  @enderror
                </div>
              </div>
              <div class="form-group d-md-flex align-items-md-center">
                <label class="control-label col-md-2" for="email"><span class="require">*</span>Email</label>
                <div class="col-md-10">
                  <input type="email" class="form-control @error('email') is-invalid @enderror" name="email"
                    value="{{ old('email') }}" id="email" placeholder="Email">
                  @error('email')
                    <span class="invalid-feedback" role="alert">
                      <strong>{{ $message }}</strong>
                    </span>
                  @enderror
                </div>
              </div>
              {{-- <div class="form-group d-md-flex align-items-md-center">
                <label class="control-label col-md-2" for="number"><span class="require">*</span>Telephone</label>
                <div class="col-md-10">
                  <input type="email" class="form-control" id="number" placeholder="Telephone">
                </div>
              </div> --}}
            </fieldset>
            <fieldset>
              <legend>Your Password</legend>
              <div class="form-group d-md-flex align-items-md-center">
                <label class="control-label col-md-2" for="pwd"><span class="require">*</span>Password:</label>
                <div class="col-md-10">
                  <input type="password" class="form-control @error('password') is-invalid @enderror" name="password" id="pwd"
                    placeholder="Password">
                  @error('password')
                    <span class="invalid-feedback" role="alert">
                      <strong>{{ $message }}</strong>
                    </span>
                  @enderror
                </div>
              </div>
              <div class="form-group d-md-flex align-items-md-center">
                <label class="control-label col-md-2" for="pwd-confirm"><span class="require">*</span>Confirm Password</label>
                <div class="col-md-10">
                  <input type="password" class="form-control" name="password_confirmation" id="pwd-confirm" placeholder="Confirm password">
                </div>
              </div>
            </fieldset>
            {{-- <fieldset class="newsletter-input">
              <legend>Newsletter</legend>
              <div class="form-group d-md-flex align-items-md-center">
                <label class="col-md-2 control-label">Subscribe</label>
                <div class="col-md-10 radio-button">
                  <label class="radio-inline"><input type="radio" name="optradio">Yes</label>
                  <label class="radio-inline"><input type="radio" name="optradio">No</label>
                </div>
              </div>
            </fieldset> --}}
            <div class="terms">
              <div class="float-md-right">
                <span>I have read and agree to the <a href="#" class="agree"><b>Privacy Policy</b></a></span>
                <input type="checkbox" name="agree" value="1"> &nbsp;
                <input type="submit" value="Continue" class="return-customer-btn">
              </div>
            </div>
          </form>
        </div>
      </div>
      <!-- Row End -->
    </div>
    <!-- Container End -->
  </div>
  <!-- Register Account End -->
@endsection
