<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\KlasifikasiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Public Routes (tidak perlu authentication)
Route::prefix('auth')->group(function () {
    Route::post('/login', [AuthController::class, 'login']);
});

// Public API routes (bisa diakses tanpa authentication)
Route::get('/public/gatra-klasifikasi', [KlasifikasiController::class, 'getGatraKlasifikasiApi']);
Route::get('/public/gatra-klasifikasi-simple', [KlasifikasiController::class, 'getGatraKlasifikasiSimpleApi']);

// Protected Routes (perlu authentication)
Route::middleware('auth:sanctum')->group(function () {
    // Auth routes
    Route::prefix('auth')->group(function () {
        Route::post('/logout', [AuthController::class, 'logout']);
        Route::get('/profile', [AuthController::class, 'profile']);
    });
    
    // Gatra routes
    Route::get('/gatra', [AuthController::class, 'getGatra']);
    
    // Gatra-Klasifikasi API routes
    Route::get('/gatra-klasifikasi', [KlasifikasiController::class, 'getGatraKlasifikasiApi']);
    Route::get('/gatra-klasifikasi-simple', [KlasifikasiController::class, 'getGatraKlasifikasiSimpleApi']);
    
    // Default user route
    Route::get('/user', function (Request $request) {
        return $request->user();
    });
});
