<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\HomepageController;
use App\Http\Controllers\InventoryController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PelacakanController;
use App\Http\Controllers\PelangganController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\SalesController;
use App\Http\Controllers\GatraController;
use App\Http\Controllers\StaffController;
use App\Http\Controllers\PenjualanController;
use App\Http\Controllers\LaporanTokoController;
use App\Http\Controllers\KlasifikasiController;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/register', function () {
    if (Auth::check()) {
        return redirect('/');
    }
    return view('register');
});
Route::post('/register', [AuthController::class, 'register']);
Route::get('/login', function () {
    if (Auth::check()) {
        return redirect('/');
    }
    return view('login');
});
Route::post('/login', [AuthController::class, 'login']);
Route::get('/logout', [AuthController::class, 'logout']);

Route::group(['middleware' => 'cekrole:Owner,Admin,Karyawan,Kurir'], function () {
    Route::resource('/admin/pelacakan', PelacakanController::class)->names('pelacakan')->except('update');
    Route::post('/admin/pelacakan/status/{id}', [PelacakanController::class, 'updateStatus'])->name('pelacakan.update.status');
    Route::put('/admin/pelacakan/{id}', [PelacakanController::class, 'update'])->name('pelacakan.update');
    Route::put('/admin/pelacakan/kurir/{id}', [PelacakanController::class, 'updateKurir'])->name('pelacakan.update.kurir');
    Route::get('/admin/ditolak/{id}', [PelacakanController::class, 'productCancel'])->name('pelacakan.product.ditolak');
});

Route::group(['middleware' => 'cekrole:Owner,Admin,Karyawan'], function () {



    // Route::get('/admin/penjualan-per-bulan/unduh', [PelacakanController::class, 'unduhPenjualanPerBulan'])
    //     ->name('penjualan_per_bulan.unduh');

    Route::get('/admin/dashboard', [AuthController::class, 'dashboard']);
    Route::resource('/admin/data-pelanggan', PelangganController::class)->names('pelanggan');
    Route::resource('/admin/data-klasifikasi', KlasifikasiController::class)->names('klasifikasi');
    Route::post('/admin/data-klasifikasi/update-all', [KlasifikasiController::class, 'updateAllKlasifikasi'])->name('klasifikasi.update.all');
    Route::resource('/admin/data-product', ProductController::class)->names('data-product');
    Route::resource('/admin/data-sales', SalesController::class)->names('data-sales');
    //gatra 
    Route::resource('/admin/data-gatra', GatraController::class)->names('data-gatra');
    Route::post('/admin/data-gatra/refresh', [GatraController::class, 'refreshGatra'])->name('data-gatra.refresh');
    Route::resource('/admin/inventory', InventoryController::class)->names('inventory');
    Route::resource('/admin/penjualan', PenjualanController::class)->names('penjualan');
    Route::get('/admin/laporan', [InventoryController::class, 'laporan'])->name('inventory.laporan');

    Route::get('/admin/unduh-laporan/{start_date}/{end_date}', [InventoryController::class, 'unduh_laporan'])->name('inventory.unduh.laporan');

    Route::get('/admin/unduh-laporan_status/{start_date}/{end_date}/{status}', [InventoryController::class, 'unduh_laporan_status'])->name('inventory.unduh.laporan_status');

    Route::get('/admin/unduh-laporan_cara/{start_date}/{end_date}/{cara}', [InventoryController::class, 'unduh_laporan_cara'])->name('inventory.unduh.laporan_cara');


    Route::get('/admin/unduh-laporan_produk/{start_date}/{end_date}/{produk}', [InventoryController::class, 'unduh_laporan_produk'])->name('inventory.unduh.laporan_produk');

    Route::get('/admin/unduh-laporan-all', [InventoryController::class, 'unduh_laporan_all'])->name('inventory.unduh.laporan_all');


    // Route::get('/admin/unduh-laporan_pembelian/{tahun}/{bulan}', [InventoryController::class, 'unduh_laporan_pembelian'])->name('inventory.unduh.laporan_pembelian');
    Route::get('/admin/unduh-laporan_pembelian/{start_date}/{end_date}', [InventoryController::class, 'unduh_laporan_pembelian'])->name('inventory.unduh.laporan_pembelian');


    Route::get('/admin/pelacakan-print', [PelacakanController::class, 'printLaporan'])->name('pelacakan.print');
    Route::get('/admin/diantar/{id}', [PelacakanController::class, 'update1']);
});

Route::group(['middleware' => 'cekrole:Owner'], function () {
    // Letakkan route custom DI ATAS resource
    Route::get('/admin/laporan_toko/penjualan_per_bulan', [LaporanTokoController::class, 'penjualan_per_bulan'])->name('penjualan_per_bulan');
    //pembelian per bulan

    Route::get('/admin/laporan_toko/pembelian_per_bulan', [LaporanTokoController::class, 'pembelian_per_bulan'])->name('pembelian_per_bulan');

    Route::get('/admin/laporan_toko/penjualan_per_produk', [LaporanTokoController::class, 'penjualan_per_produk'])->name('penjualan_per_produk');


    Route::get('/admin/laporan_toko/penjualan_per_bulan/{tahun}/{bulan}', [LaporanTokoController::class, 'pelacakan_per_bulan'])->name('laporan_toko.pelacakan_per_bulan');

    Route::get('/admin/laporan_toko/pembelian_all', [LaporanTokoController::class, 'pembelian_all'])->name('pembelian_all');

    Route::get('/admin/laporan_toko/penjualan_all', [LaporanTokoController::class, 'penjualan_all'])->name('penjualan_all');

    Route::get('/admin/laporan_toko/penjualan_per_status', [LaporanTokoController::class, 'penjualan_per_status'])->name('penjualan_per_status');

    Route::get('/admin/laporan_toko/penjualan_per_cara_bayar', [LaporanTokoController::class, 'penjualan_per_cara_bayar'])->name('penjualan_per_cara_bayar');


    // Route::get('/admin/laporan_toko/laporan/penjualan_per_bulan', [LaporanTokoController::class, 'penjualan_per_bulan'])->name('penjualan_per_bulan');

    Route::resource('/admin/data-staff', StaffController::class)->names('data-staff');
    Route::resource('/admin/laporan_toko', LaporanTokoController::class)->names('laporan_toko');
});

// Homepage
// Route::get('/', [HomepageController::class, 'index'])->name('homepage');
// set default to login
Route::get('/', function () {
    if (Auth::check()) {
        return redirect('/admin/data-klasifikasi');
    }
    return redirect('/login');
})->name('homepage');
Route::get('/product/{id}', [HomepageController::class, 'getProductById'])->name('product.detail');
Route::get('/search', [HomepageController::class, 'search'])->name('product.search');
Route::group(['middleware' => 'cekrole:Owner,Admin,Karyawan,Kurir,Customer'], function () {
    // Route::put('/pesanan/{id}/terima', [PelacakanController::class, 'customerSelesai'])->name('pelacakan.customer.terima');
    Route::put('/pesanan/{id}/terima', [PelacakanController::class, 'customerSelesai'])->name('pelacakan.customer.terima');




    Route::put('/profile', [HomepageController::class, 'updateProfile'])->name('profile.update');
    Route::get('/cart', [HomepageController::class, 'getCart'])->name('product.cart');
    Route::get('/cart/data', [HomepageController::class, 'getCartDataResponse'])->name('cart.data');
    Route::post('/cart/{id}', [HomepageController::class, 'addToCart'])->name('product.add.cart');
    Route::post('/cart/update/{id}', [HomepageController::class, 'updateCart'])->name('product.update.cart');
    Route::delete('/cart/{id}', [HomepageController::class, 'removeFromCart'])->name('product.remove.cart');
    Route::get('/checkout', [HomepageController::class, 'getCheckout'])->name('product.checkout');
    Route::get('/orders', [HomepageController::class, 'getOrder'])->name('product.order');
    Route::post('/orders', [HomepageController::class, 'order'])->name('product.create.order');
    Route::get('/bayar-cicilan/{id}', [HomepageController::class, 'formBayarCicilan'])->name('product.bayar.cicilan.form');
    Route::post('/bayar-cicilan/{id}', [HomepageController::class, 'bayarCicilan'])->name('product.bayar.cicilan');
});
